package com.ruoyi.inventory.domain.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.alibaba.excel.enums.poi.FillPatternTypeEnum;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
//import org.apache.poi.ss.usermodel.FillPatternType;

import java.io.Serializable;

/**
 * 库存汇总统计VO
 * 
 * @author cy
 * @date 2025-12-03
 */
@HeadStyle(fillPatternType = FillPatternTypeEnum.NO_FILL, fillForegroundColor = 10)
@HeadFontStyle(fontHeightInPoints = 12)
@ColumnWidth(15)
@Data
public class InventorySummaryVO implements Serializable
{
    private static final long serialVersionUID = 1L;

    /** 物料ID */
    @ExcelProperty(value = "物料ID", index = 0)
    private String materialId;

    /** 物料名称 */
    @ExcelProperty(value = "物料名称", index = 1)
    private String materialName;

    /** 最低库存 */
    private Long minStockLevel;
    /** 最高库存 */
    private Long maxStockLevel;

    /** SAP物料号 */
    @Excel(name = "SAP物料号")
    private String sapNo;

    /** TS Code */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 危险类别 */
    private String hazardId;

    /** 危险类别 */
    @Excel(name = "危险类别")
    private String hazard;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String specification;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String materialUnit;

    /** 单位重量 */
    @Excel(name = "单位重量")
    private Double unitWeight;

    /** 包装重量 */
//    @Excel(name = "包装重量")
    private Double packageWeight;

    /** 总重量 */
    private Double totalWeight;

    /** 体积 */
    private Double volume;

    /** 保质期天数 */
    private Integer shelfLifeDays;

    /** 存储温度要求 */
//    @Excel(name = "存储温度要求")
    private String storageTemperature;

    /** 特殊存储要求 */
//    @Excel(name = "特殊存储要求")
    private String specialRequirements;

    /** 总库存数量 */
    @ExcelProperty(value = "总库存数量", index = 9)
    private Long totalQuantity;

    /** 总锁定数量 */
    @ExcelProperty(value = "总锁定数量", index = 10)
    private Long totalLockedQuantity;

    /** 总可用数量 */
    @ExcelProperty(value = "总可用数量", index = 11)
    private Long totalAvailableQuantity;

    private String alterType;

}

