package com.ruoyi.inventory.domain.vo;

import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * 客户信息实体类
 *
 * @author 豆包编程助手
 * @date 2025-12-11
 */
@Data
public class OwnerTemplateVO {

    /**
     * 客户编码/客户名称（根据业务场景调整，若为编码建议命名为 customerCode）
     */
    @Excel(name = "客户")
    private String ownerCode;

    /**
     * 激活状态（如：是/否、已激活/未激活，建议用布尔值或枚举）
     */

    @Excel(name = "激活",dictType = "yorn")
    private String isActive;

    /**
     * 客户类型（如：个人/企业、经销商/终端客户等）
     */
    @Excel(name = "类型",dictType="owner_type")
    private String ownerType;

    /**
     * 客户中文名称
     */
    @Excel(name = "中文名称")
    private String ownerName;

    /**
     * 客户英文名称
     */
    @Excel(name = "英文名称")
    private String englishName;

    /**
     * 地址1（主地址）
     */
    @Excel(name = "地址1")
    private String address;

    /**
     * 联系人1（主要联系人）
     */
    @Excel(name = "电话1")
    private String contactPerson;

    /**
     * 电话1（主要联系电话）
     */
    @Excel(name = "联系人1")
    private String contactPhone;
}