package com.ruoyi.inventory.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.inventory.domain.vo.InboundOutboundStatisticsVO;
import com.ruoyi.inventory.service.IInventoryStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 出入库统计
 */
@RestController
@RequestMapping("/inventory/statistics")
public class InventoryStatisticsController extends BaseController {

    @Autowired
    private IInventoryStatisticsService inventoryStatisticsService;

    /**
     * 出入库统计列表
     */
//    @PreAuthorize("@ss.hasPermi('inventory:statistics:list')")
    @GetMapping("/inboundOutbound")
    public TableDataInfo list(InboundOutboundStatisticsVO query) {
        startPage();
        List<InboundOutboundStatisticsVO> list = inventoryStatisticsService.selectInboundOutboundStatistics(query);
        return getDataTable(list);
    }

    /**
     * 导出出入库统计
     */
    @PreAuthorize("@ss.hasPermi('inventory:statistics:export')")
    @Log(title = "出入库统计", businessType = BusinessType.EXPORT)
    @PostMapping("/inboundOutbound/export")
    public void export(HttpServletResponse response, InboundOutboundStatisticsVO query) {
        List<InboundOutboundStatisticsVO> list = inventoryStatisticsService.selectInboundOutboundStatistics(query);
        ExcelUtil<InboundOutboundStatisticsVO> util = new ExcelUtil<>(InboundOutboundStatisticsVO.class);
        util.exportExcel(response, list, "出入库统计数据");
    }
}

