package com.ruoyi.inventory.domain;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 出库单主对象 outbound_orders
 *
 * @author ruoyi
 * @date 2025-12-03
 */
@Data
public class OutboundOrders extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 出库单号 检索条件 */
    @Excel(name = "出库单号 检索条件")
    private String orderId;

    /** 系统编号 检索条件 */
    @Excel(name = "系统编号 检索条件")
    private String systemNo;

    /** 入库类型 字典，检索条件 */
    @Excel(name = "入库类型 字典，检索条件")
    private String orderTypeId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID 检索条件")
    private String batchCode;

    /** 仓库ID 暂无用 */
    @Excel(name = "仓库ID 暂无用")
    private String warehouseId;

    /** 仓库名称 暂无用 */
    @Excel(name = "仓库ID 暂无用")
    private String warehouseName;

    /** 货主ID */
    @Excel(name = "货主ID")
    private String ownerId;

    /** 货主名称 */
    @Excel(name = "货主ID")
    private String ownerName;

    /** 出库单状态1-草稿 2-已完成 3-已取消 字典，检索条件 */
    @Excel(name = "出库单状态1-草稿 2-已完成 3-已取消 字典，检索条件")
    private Long orderStatus;

    /** 开始日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /** 结束日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;


    /** 出库日期 日期无时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出库日期 日期无时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundDate;

    /** 目的地 */
    @Excel(name = "目的地")
    private String destination;

    /** 计划量 暂无用 */
    @Excel(name = "计划量 暂无用")
    private Long totalPlannedQuantity;

    /** 实际量 暂无用 */
    @Excel(name = "实际量 暂无用")
    private Long totalActualQuantity;

    /** 总件数 暂无用 */
    @Excel(name = "总件数 暂无用")
    private Long totalPackages;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    private String orderType;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    /** 出库单明细信息 */
    private List<OutboundOrderItems> outboundOrderItemsList;

}