package com.ruoyi.inventory.service;

import java.util.List;

import com.ruoyi.inventory.domain.ReturnOrderItems;
import com.ruoyi.inventory.domain.ReturnOrders;

/**
 * 退库单主Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IReturnOrdersService 
{
    /**
     * 查询退库单主
     * 
     * @param id 退库单主主键
     * @return 退库单主
     */
    public ReturnOrders selectReturnOrdersById(String id);

    /**
     * 查询退库单主列表
     * 
     * @param returnOrders 退库单主
     * @return 退库单主集合
     */
    public List<ReturnOrders> selectReturnOrdersList(ReturnOrders returnOrders);

    /**
     * 新增退库单主
     * 
     * @param returnOrders 退库单主
     * @return 结果
     */
    public int insertReturnOrders(ReturnOrders returnOrders);

    /**
     * 修改退库单主
     * 
     * @param returnOrders 退库单主
     * @return 结果
     */
    public int updateReturnOrders(ReturnOrders returnOrders);

    /**
     * 批量删除退库单主
     * 
     * @param ids 需要删除的退库单主主键集合
     * @return 结果
     */
    public int deleteReturnOrdersByIds(String[] ids);

    /**
     * 删除退库单主信息
     * 
     * @param id 退库单主主键
     * @return 结果
     */
    public int deleteReturnOrdersById(String id);

    /**
     * 查询退库单明细列表
     *
     * @param returnOrders 退库单明细
     * @return 退库单明细集合
     */
    public List<ReturnOrderItems> selectExportList(ReturnOrders returnOrders);

    /**
     * @退库确认
     * @param ids 需要确认的退库单主主键集合
     * @return
     */
    public int confirmReturnOrdersByIds(String[] ids);
}

