package com.ruoyi.inventory.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.ruoyi.common.core.domain.entity.Materials;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.inventory.domain.InboundOrderItems;
import com.ruoyi.inventory.domain.InboundOrders;
import com.ruoyi.inventory.domain.vo.inboundVO.InboundTemplateVO;
import com.ruoyi.inventory.domain.vo.OutboundOrdersSummaryVO;
import com.ruoyi.inventory.domain.vo.OutboundTemplateVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.OutboundOrderItemsMapper;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.service.IOutboundOrderItemsService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 出库单明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@Service
public class OutboundOrderItemsServiceImpl implements IOutboundOrderItemsService 
{
    @Autowired
    private OutboundOrderItemsMapper outboundOrderItemsMapper;

    @Autowired
    private InventoryServiceImpl inventoryService;

    @Autowired
    private OutboundOrderLogServiceImpl outboundOrderLogService;
    /**
     * 查询出库单明细
     * 
     * @param id 出库单明细主键
     * @return 出库单明细
     */
    @Override
    public OutboundOrderItems selectOutboundOrderItemsById(String id)
    {
        return outboundOrderItemsMapper.selectOutboundOrderItemsById(id);
    }

    /**
     * 查询出库单明细列表
     * 
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细
     */
    @Override
    public List<OutboundOrderItems> selectOutboundOrderItemsList(OutboundOrderItems outboundOrderItems)
    {
        return outboundOrderItemsMapper.selectOutboundOrderItemsList(outboundOrderItems);
    }

    @Override
    public List<OutboundOrdersSummaryVO> selectOutboundOrderItemsStatistics(OutboundOrdersSummaryVO outboundOrderItems) {
        List<OutboundOrdersSummaryVO> list = outboundOrderItemsMapper.selectOutboundOrderItemsStatistics(outboundOrderItems);
        return list;
    }

    @Override
    public List<OutboundOrderItems> selectOutboundOrderItemsStatisticsList(OutboundOrderItems outboundOrderItems) {
        List<OutboundOrderItems> list = outboundOrderItemsMapper.selectOutboundOrderItemsStatisticsList(outboundOrderItems);
        return list;
    }

    @Override
    public int insertOutboundOrderItems(OutboundOrderItems outboundOrderItems)
    {
        outboundOrderItems.setCreateTime(DateUtils.getNowDate());
        return outboundOrderItemsMapper.insertOutboundOrderItems(outboundOrderItems);
    }


    @Override
    public int updateOutboundOrderItems(OutboundOrderItems outboundOrderItems)
    {
        outboundOrderItems.setUpdateTime(DateUtils.getNowDate());
        return outboundOrderItemsMapper.updateOutboundOrderItems(outboundOrderItems);
    }

    /**
     * 批量删除出库单明细
     * 
     * @param ids 需要删除的出库单明细主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderItemsByIds(String[] ids)
    {
        return outboundOrderItemsMapper.deleteOutboundOrderItemsById(ids);
    }

    /**
     * 删除出库单明细信息
     * 
     * @param id 出库单明细主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderItemsById(String id)
    {
        return outboundOrderItemsMapper.deleteOutboundOrderItemsById(id);
    }



}
