package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.common.utils.uuid.UUID;
import com.ruoyi.inventory.domain.MaterialsCategory;
import com.ruoyi.inventory.domain.StorageLocationsCategory;
import com.ruoyi.inventory.mapper.MaterialsCategoryMapper;
import com.ruoyi.inventory.mapper.StorageLocationsCategoryMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.StorageLocationsMapper;
import com.ruoyi.inventory.domain.StorageLocations;
import com.ruoyi.inventory.service.IStorageLocationsService;

/**
 * 库位Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
@Service
public class StorageLocationsServiceImpl implements IStorageLocationsService 
{
    @Autowired
    private StorageLocationsMapper storageLocationsMapper;
    @Autowired
    private StorageLocationsCategoryMapper storageLocationsCategoryMapper;
    @Autowired
    private MaterialsCategoryMapper materialsCategoryMapper;

    /**
     * 查询库位
     * 
     * @param id 库位主键
     * @return 库位
     */
    @Override
    public StorageLocations selectStorageLocationsById(String id)
    {
        return storageLocationsMapper.selectStorageLocationsById(id);
    }

    @Override
    public List<StorageLocations> selectStorageLocationsByWarehousesCode(String warehousesCode) {
        return storageLocationsMapper.selectStorageLocationsByWarehousesCode(warehousesCode);
    }

    @Override
    public List<StorageLocations> selectStorageLocationsByWarehousesCodes(String[] warehousesCodes) {
        return storageLocationsMapper.selectStorageLocationsByWarehousesCodes(warehousesCodes);
    }

    /**
     * 查询库位列表
     * 
     * @param storageLocations 库位
     * @return 库位
     */
    @Override
    public List<StorageLocations> selectStorageLocationsList(StorageLocations storageLocations)
    {
        return storageLocationsMapper.selectStorageLocationsList(storageLocations);
    }

    /**
     * 新增库位
     * 
     * @param storageLocations 库位
     * @return 结果
     */
    @Override
    public int insertStorageLocations(StorageLocations storageLocations)
    {
        storageLocations.setCreateTime(DateUtils.getNowDate());

        StorageLocationsCategory storageLocationsCategory = new StorageLocationsCategory();
        BeanUtils.copyBeanProp(storageLocations,storageLocationsCategory);
        String LocationsID = UUID.randomUUID().toString();
        storageLocations.setId(LocationsID);
        storageLocations.setCreateTime(DateUtils.getNowDate());
        storageLocations.setCreateUserCode(String.valueOf(SecurityUtils.getUserId()));
        storageLocationsCategory.setLocationCode(LocationsID);

        String[] CategoryId = storageLocations.getAllowedCategoryIds().split(",");
        for (String categoryId : CategoryId) {
            storageLocationsCategory.setId(java.util.UUID.randomUUID().toString());
            storageLocationsCategory.setCategoryId(categoryId);
            storageLocationsCategory.setCreateTime(DateUtils.getNowDate());
            storageLocationsCategory.setCreateUserCode(String.valueOf(SecurityUtils.getUserId()));
            MaterialsCategory materialsCategory = materialsCategoryMapper.selectMaterialsCategoryById(categoryId);
            storageLocationsCategory.setCategoryName(materialsCategory.getCategoryName());
            storageLocationsCategoryMapper.insertStorageLocationsCategory(storageLocationsCategory);
        }
        return storageLocationsMapper.insertStorageLocations(storageLocations);
    }

    /**
     * 修改库位
     * 
     * @param storageLocations 库位
     * @return 结果
     */
    @Override
    public int updateStorageLocations(StorageLocations storageLocations)
    {
        storageLocations.setUpdateTime(DateUtils.getNowDate());
        storageLocations.setUpdateUserCode(String.valueOf(SecurityUtils.getUserId()));

        String LocationsID = storageLocations.getId();
        String LocationsCode = storageLocations.getLocationCode();
        StorageLocations storageLocations1 = storageLocationsMapper.selectStorageLocationsById(LocationsID);
        if (storageLocations1.getAllowedCategoryIds()!=storageLocations.getAllowedCategoryIds()||storageLocations1.getIsEnabled()!=storageLocations.getIsEnabled()){
            storageLocationsCategoryMapper.deleteStorageLocationsCategoryByLocationCode(LocationsID);

            String[] CategoryId = storageLocations.getAllowedCategoryIds().split(",");
            StorageLocationsCategory storageLocationsCategory = new StorageLocationsCategory();
            BeanUtils.copyBeanProp(storageLocations,storageLocationsCategory);

            storageLocationsCategory.setLocationCode(LocationsID);
            for (String categoryId : CategoryId) {
                storageLocations.setId(java.util.UUID.randomUUID().toString());
                storageLocationsCategory.setCategoryId(categoryId);
                storageLocationsCategory.setUpdateTime(DateUtils.getNowDate());
                storageLocationsCategory.setUpdateUserCode(String.valueOf(SecurityUtils.getUserId()));
                MaterialsCategory materialsCategory = materialsCategoryMapper.selectMaterialsCategoryById(categoryId);
                storageLocationsCategory.setCategoryName(materialsCategory.getCategoryName());
                storageLocationsCategoryMapper.insertStorageLocationsCategory(storageLocationsCategory);
            }
        }

        return storageLocationsMapper.updateStorageLocations(storageLocations);
    }

    /**
     * 批量删除库位
     * 
     * @param ids 需要删除的库位主键
     * @return 结果
     */
    @Override
    public int deleteStorageLocationsByIds(String[] ids)
    {
        storageLocationsCategoryMapper.deleteStorageLocationsCategoryByIds(ids);
        return storageLocationsMapper.deleteStorageLocationsByIds(ids);
    }

    /**
     * 删除库位信息
     * 
     * @param id 库位主键
     * @return 结果
     */
    @Override
    public int deleteStorageLocationsById(String id)
    {
        storageLocationsCategoryMapper.deleteStorageLocationsCategoryById(id);
        return storageLocationsMapper.deleteStorageLocationsById(id);
    }

    @Override
    public int updateLocationsCategoryStatus(String id)
    {
        storageLocationsCategoryMapper.updateStorageLocationsCategoryStatus(id);
        return storageLocationsMapper.updateStorageLocationsStatus(id);
    }
}
