package com.ruoyi.inventory.domain;

import com.fasterxml.jackson.annotation.JsonTypeId;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 货主信息对象 owners
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public class Owners extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */

    private String id;

    /** 货主编码 检索条件 */
    @Excel(name = "货主编码")
    private String ownerCode;

    /** 货主名称 检索条件 */
    @Excel(name = "货主名称")
    private String ownerName;

    @Excel(name = "货主名称")
    private String englishName;

    /** 货主类型 1-供应商 2-客户 3-内部 检索条件 */
    @Excel(name = "货主类型")
    private Long ownerType;

    /** 联系人 */
    @Excel(name = "联系人")
    private String contactPerson;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String contactPhone;

    /** 邮箱 */
    @Excel(name = "邮箱")
    private String email;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 税号 检索条件 */
    @Excel(name = "税号")
    private String taxNumber;

    /** 银行账户 */
    @Excel(name = "银行账户")
    private String bankAccount;

    /** 是否激活 1-是 0-否 检索条件 */

    private Long isActive;

    /** 排序 */

    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    /** 删除标识 1-是 0-否 */
    private Long isUsed;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setOwnerCode(String ownerCode) 
    {
        this.ownerCode = ownerCode;
    }

    public String getOwnerCode() 
    {
        return ownerCode;
    }

    public void setOwnerName(String ownerName) 
    {
        this.ownerName = ownerName;
    }

    public String getOwnerName() 
    {
        return ownerName;
    }

    public void setOwnerType(Long ownerType) 
    {
        this.ownerType = ownerType;
    }

    public Long getOwnerType() 
    {
        return ownerType;
    }

    public void setContactPerson(String contactPerson) 
    {
        this.contactPerson = contactPerson;
    }

    public String getContactPerson() 
    {
        return contactPerson;
    }

    public String getEnglishName() {
        return englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public void setContactPhone(String contactPhone)
    {
        this.contactPhone = contactPhone;
    }

    public String getContactPhone() 
    {
        return contactPhone;
    }

    public void setEmail(String email) 
    {
        this.email = email;
    }

    public String getEmail() 
    {
        return email;
    }

    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }

    public void setTaxNumber(String taxNumber) 
    {
        this.taxNumber = taxNumber;
    }

    public String getTaxNumber() 
    {
        return taxNumber;
    }

    public void setBankAccount(String bankAccount) 
    {
        this.bankAccount = bankAccount;
    }

    public String getBankAccount() 
    {
        return bankAccount;
    }

    public void setIsActive(Long isActive) 
    {
        this.isActive = isActive;
    }

    public Long getIsActive() 
    {
        return isActive;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    public void setIsUsed(Long isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed() 
    {
        return isUsed;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("ownerCode", getOwnerCode())
            .append("ownerName", getOwnerName())
            .append("ownerType", getOwnerType())
            .append("contactPerson", getContactPerson())
            .append("contactPhone", getContactPhone())
            .append("email", getEmail())
            .append("address", getAddress())
            .append("taxNumber", getTaxNumber())
            .append("bankAccount", getBankAccount())
            .append("isActive", getIsActive())
            .append("english_name", getEnglishName())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .append("isUsed", getIsUsed())
            .toString();
    }
}
