package com.ruoyi.inventory.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.inventory.domain.StorageLocations;
import com.ruoyi.inventory.service.IWarehousesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.WarehousesMapper;
import com.ruoyi.inventory.domain.Warehouses;

/**
 * 仓库Service业务层处理
 *
 * @author ruoyi
 * @date 2025-12-01
 */
@Service
public class WarehousesServiceImpl implements IWarehousesService
{
    @Autowired
    private WarehousesMapper warehousesMapper;
    @Autowired
    private StorageLocationsServiceImpl storageLocationsService;

    /**
     * 查询仓库
     *
     * @param id 仓库主键
     * @return 仓库
     */
    @Override
    public Warehouses selectWarehousesById(String id)
    {
        return warehousesMapper.selectWarehousesById(id);
    }

    /**
     * 查询仓库列表
     *
     * @param warehouses 仓库
     * @return 仓库
     */
    @Override
    public List<Warehouses> selectWarehousesList(Warehouses warehouses)
    {
        return warehousesMapper.selectWarehousesList(warehouses);
    }

    /**
     * 新增仓库
     *
     * @param warehouses 仓库
     * @return 结果
     */
    @Override
    public int insertWarehouses(Warehouses warehouses)
    {
        warehouses.setCreateTime(DateUtils.getNowDate());
        warehouses.setCreateUserCode(String.valueOf(SecurityUtils.getUserId()));
        warehouses.setId(UUID.randomUUID().toString());
        return warehousesMapper.insertWarehouses(warehouses);
    }

    /**
     * 修改仓库
     *
     * @param warehouses 仓库
     * @return 结果
     */
    @Override
    public int updateWarehouses(Warehouses warehouses)
    {
        warehouses.setUpdateUserCode(String.valueOf(SecurityUtils.getUserId()));
        warehouses.setUpdateTime(DateUtils.getNowDate());
        Warehouses warehouses1 = warehousesMapper.selectWarehousesById(warehouses.getId());
        if (warehouses1.getIsEnabled()!=warehouses.getIsEnabled()){
            updateWarehouseStatus(warehouses);
        }
        return warehousesMapper.updateWarehouses(warehouses);
    }
    @Override
    public int updateWarehouseStatus(Warehouses warehouses)
    {
        storageLocationsService.updateLocationsCategoryStatus(warehouses.getWarehousesCode());
        return warehousesMapper.updateWarehouseStatus(warehouses.getId());
    }

    /**
     * 批量删除仓库
     *
     * @param ids 需要删除的仓库主键
     * @return 结果
     */
    @Override
    public int deleteWarehousesByIds(String[] ids)
    {
        List<String> WarehousesCodes = new ArrayList<>();
        for (String id : ids){
            Warehouses warehouses = selectWarehousesById(id);
            String warehousesCode = warehouses.getWarehousesCode();
            WarehousesCodes.add(warehousesCode);
        }
        List<StorageLocations> storageLocations = new ArrayList<>();
        if (WarehousesCodes!=null && !WarehousesCodes.isEmpty()){
            storageLocations= storageLocationsService.selectStorageLocationsByWarehousesCodes(WarehousesCodes);
        }
          for (StorageLocations storageLocation : storageLocations) {
            storageLocationsService.deleteStorageLocationsById(storageLocation.getId());
        }
        return warehousesMapper.deleteWarehousesByIds(ids);
    }

    /**
     * 删除仓库信息
     *
     * @param id 仓库主键
     * @return 结果
     */
    @Override
    public int deleteWarehousesById(String id)
    {
        List<StorageLocations> storageLocations = storageLocationsService.selectStorageLocationsByWarehousesCode(id);
        for (StorageLocations storageLocation : storageLocations) {
            storageLocationsService.deleteStorageLocationsById(storageLocation.getId());
        }
        return warehousesMapper.deleteWarehousesById(id);
    }

    /**
     * @description: 获取仓库 的 warehouses_code 仓库编码 warehouses_name 做成字典
     * @author cs
     * @date 2025/12/4
     * @version 1.0
     */
    @Override
    public List<Map<String, Object>> getMapList(){
        return warehousesMapper.getMapList();
    }
}
