import request from '@/utils/request'

// 查询入库单明细列表
export function listInbound_items(query) {
  return request({
    url: '/inventory/inbound_items/list',
    method: 'get',
    params: query
  })
}
// 查询入库单明细列表联查materialname
export function listInbound_itemsAndMname(query) {
  return request({
    url: '/inventory/inbound_items/listAndMname',
    method: 'get',
    params: query
  })
}
// 查询入库单明细详细
export function getInbound_items(id) {
  return request({
    url: '/inventory/inbound_items/' + id,
    method: 'get'
  })
}

// 新增入库单明细
export function addInbound_items(data) {
  return request({
    url: '/inventory/inbound_items',
    method: 'post',
    data: data
  })
}

// 修改入库单明细
export function updateInbound_items(data) {
  return request({
    url: '/inventory/inbound_items',
    method: 'put',
    data: data
  })
}

// 删除入库单明细
export function delInbound_items(id) {
  return request({
    url: '/inventory/inbound_items/' + id,
    method: 'delete'
  })
}

// 统计入库单明细
export function inbound_details(query){
  return request({
    url: '/inventory/inbound_items/details',
    method: 'get',
    params: query
  })
}
