package com.ruoyi.inventory.domain.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.alibaba.excel.enums.poi.FillPatternTypeEnum;
import lombok.Data;
//import org.apache.poi.ss.usermodel.FillPatternType;

import java.io.Serializable;

/**
 * 库存汇总统计VO
 * 
 * @author cy
 * @date 2025-12-03
 */
@HeadStyle(fillPatternType = FillPatternTypeEnum.NO_FILL, fillForegroundColor = 10)
@HeadFontStyle(fontHeightInPoints = 12)
@ColumnWidth(15)
@Data
public class InventorySummaryVO implements Serializable
{
    private static final long serialVersionUID = 1L;

    /** 物料ID */
    @ExcelProperty(value = "物料ID", index = 0)
    private String materialId;

    /** 物料名称 */
    @ExcelProperty(value = "物料名称", index = 1)
    private String materialName;

    /** 库存类别 */
    @ExcelProperty(value = "库存类别", index = 2)
    private String inventoryTypeName;

    /** 仓库编码 */
    @ExcelProperty(value = "仓库编码", index = 3)
    private String warehousesCode;

    /** 仓库名称 */
    @ExcelProperty(value = "仓库名称", index = 4)
    private String warehouseName;

    /** 库位ID */
    @ExcelProperty(value = "库位ID", index = 5)
    private String locationId;

    /** 库位名称 */
    @ExcelProperty(value = "库位名称", index = 6)
    private String locationName;

    /** 货主ID */
    @ExcelProperty(value = "货主ID", index = 7)
    private String ownerId;

    /** 货主名称 */
    @ExcelProperty(value = "货主名称", index = 8)
    private String ownerName;

    /** 总库存数量 */
    @ExcelProperty(value = "总库存数量", index = 9)
    private Long totalQuantity;

    /** 总锁定数量 */
    @ExcelProperty(value = "总锁定数量", index = 10)
    private Long totalLockedQuantity;

    /** 总可用数量 */
    @ExcelProperty(value = "总可用数量", index = 11)
    private Long totalAvailableQuantity;

    /** 总重量 */
    @ExcelProperty(value = "总重量", index = 12)
    private Double totalWeight;

    /** 总体积 */
    @ExcelProperty(value = "总体积", index = 13)
    private Double totalVolume;

    /** 库存状态 */
    @ExcelProperty(value = "库存状态", index = 14)
    private String inventoryStatusName;

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getInventoryTypeName() {
        return inventoryTypeName;
    }

    public void setInventoryTypeName(String inventoryTypeName) {
        this.inventoryTypeName = inventoryTypeName;
    }

    public String getWarehousesCode() {
        return warehousesCode;
    }

    public void setWarehousesCode(String warehousesCode) {
        this.warehousesCode = warehousesCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Long getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Long totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Long getTotalLockedQuantity() {
        return totalLockedQuantity;
    }

    public void setTotalLockedQuantity(Long totalLockedQuantity) {
        this.totalLockedQuantity = totalLockedQuantity;
    }

    public Long getTotalAvailableQuantity() {
        return totalAvailableQuantity;
    }

    public void setTotalAvailableQuantity(Long totalAvailableQuantity) {
        this.totalAvailableQuantity = totalAvailableQuantity;
    }

    public Double getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(Double totalWeight) {
        this.totalWeight = totalWeight;
    }

    public Double getTotalVolume() {
        return totalVolume;
    }

    public void setTotalVolume(Double totalVolume) {
        this.totalVolume = totalVolume;
    }

    public String getInventoryStatusName() {
        return inventoryStatusName;
    }

    public void setInventoryStatusName(String inventoryStatusName) {
        this.inventoryStatusName = inventoryStatusName;
    }
}

