package com.ruoyi.inventory.domain.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.alibaba.excel.enums.poi.FillPatternTypeEnum;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 库存汇总统计VO
 * 
 * @author cy
 * @date 2025-12-08
 */
//@HeadStyle(fillPatternType = FillPatternTypeEnum.NO_FILL, fillForegroundColor = 10)
//@HeadFontStyle(fontHeightInPoints = 12)
//@ColumnWidth(15)
@Data
public class ReturnOrdersSummaryVO extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 物料ID */
    private String materialId;

    /** 物料名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** SAP物料号 */
    @Excel(name = "SAP物料号")
    private String sapNo;

    /** TS Code */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 危险类别 */
    private String hazardId;

    /** 危险类别 */
    @Excel(name = "危险类别")
    private String hazard;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String specification;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String materialUnit;

    /** 单位重量 */
    @Excel(name = "单位重量")
    private Double unitWeight;

    /** 包装重量 */
//    @Excel(name = "包装重量")
    private Double packageWeight;

    /** 总重量 */
    private Double totalWeight;

    /** 体积 */
    private Double volume;

    /** 保质期天数 */
    private Integer shelfLifeDays;

    /** 总重量 */
//    @Excel(name = "总重量")
    private Double totalQuantity;

    /** 体积 */
//    @Excel(name = "体积")
    private Double totalLockedQuantity;

    /** 保质期天数 */
//    @Excel(name = "保质期天数")
    private Integer totalAvailableQuantity;

    /** 存储温度要求 */
//    @Excel(name = "存储温度要求")
    private String storageTemperature;

    /** 特殊存储要求 */
//    @Excel(name = "特殊存储要求")
    private String specialRequirements;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Integer plannedQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Integer actualQuantity;

    /** 总量 */
    @Excel(name = "总量")
    private Double totalAmount;



}

