package com.ruoyi.inventory.service.impl;

import java.util.List;
import java.util.Map;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.inventory.domain.TO.StocktakeItemsTo;
import com.ruoyi.inventory.domain.TO.StocktakesVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.StocktakeItemsMapper;
import com.ruoyi.inventory.domain.StocktakeItems;
import com.ruoyi.inventory.service.IStocktakeItemsService;

/**
 * 盘点单明细Service业务层处理
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@Service
public class StocktakeItemsServiceImpl implements IStocktakeItemsService
{
    @Autowired
    private StocktakeItemsMapper stocktakeItemsMapper;

    /**
     * 查询盘点单明细
     *
     * @param id 盘点单明细主键
     * @return 盘点单明细
     */
    @Override
    public StocktakeItems selectStocktakeItemsById(String id)
    {
        return stocktakeItemsMapper.selectStocktakeItemsById(id);
    }

    /**
     * @description: 主表调用获取子表信息
     * @author cs
     * @date 2025/12/5
     * @version 1.0
     */
    public List<StocktakeItemsTo> selectStocktakeItemsByMain(Map<String,Object> query){
        return stocktakeItemsMapper.selectStocktakeItemsByMain(query);
    }
    /**
     * 查询盘点单明细列表
     *
     * @param stocktakeItems 盘点单明细
     * @return 盘点单明细
     */
    @Override
    public List<StocktakeItems> selectStocktakeItemsList(StocktakeItems stocktakeItems)
    {
        return stocktakeItemsMapper.selectStocktakeItemsList(stocktakeItems);
    }

    /**
     * 新增盘点单明细
     *
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    @Override
    public int insertStocktakeItems(StocktakeItems stocktakeItems)
    {
        stocktakeItems.setCreateTime(DateUtils.getNowDate());
        return stocktakeItemsMapper.insertStocktakeItems(stocktakeItems);
    }

    /**
     * 修改盘点单明细
     *
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    @Override
    public int updateStocktakeItems(StocktakeItems stocktakeItems)
    {
//        stocktakeItems.setUpdateTime(DateUtils.getNowDate());
        return stocktakeItemsMapper.updateStocktakeItems(stocktakeItems);
    }

    /**
     * 批量删除盘点单明细
     *
     * @param ids 需要删除的盘点单明细主键
     * @return 结果
     */
    @Override
    public int deleteStocktakeItemsByIds(String[] ids)
    {
        return stocktakeItemsMapper.deleteStocktakeItemsByIds(ids);
    }

    /**
     * 删除盘点单明细信息
     *
     * @param id 盘点单明细主键
     * @return 结果
     */
    @Override
    public int deleteStocktakeItemsById(String id)
    {
        return stocktakeItemsMapper.deleteStocktakeItemsById(id);
    }

//    查询处理统计-详情
    @Override
    public List<StocktakesVo> selectStocktakesCountInfo(StocktakesVo stocktakes){
        String plannedDates = stocktakes.getPlannedDates();
        String warehousesId = stocktakes.getWarehousesId();
        String locationId = stocktakes.getLocationId();
        if (plannedDates != null && !plannedDates.isEmpty()) {
            stocktakes.setPlannedDateArray(plannedDates.split(","));
        }
        // 2. 拆分仓库ID
        if (warehousesId != null && !warehousesId.isEmpty()) {
            stocktakes.setWarehouseIdArray(warehousesId.split(","));
        }
        // 3. 拆分库位ID
        if (locationId != null && !locationId.isEmpty()) {
            stocktakes.setLocationIdArray(locationId.split(","));
        }
        return stocktakeItemsMapper.selectStocktakesCountInfo(stocktakes);
    }
}
