import request from '@/utils/request'

// 查询退库单列表
export function listReturnOrders(query) {
  return request({
    url: '/inventory/return_orders/list',
    method: 'get',
    params: query
  })
}

// 查询退库单详细
export function getReturnOrder(id) {
  return request({
    url: '/inventory/return_orders/' + id,
    method: 'get'
  })
}

// 新增退库单
export function addReturnOrder(data) {
  return request({
    url: '/inventory/return_orders',
    method: 'post',
    data: data
  })
}

// 修改退库单
export function updateReturnOrder(data) {
  return request({
    url: '/inventory/return_orders',
    method: 'put',
    data: data
  })
}

// 删除退库单
export function delReturnOrder(id) {
  return request({
    url: '/inventory/return_orders/' + id,
    method: 'delete'
  })
}

// 确认退库单
export function confirmReturnOrder(id) {
  return request({
    url: '/inventory/return_orders/confirm/' + id,
    method: 'post'
  })
}

