package com.ruoyi.inventory.domain;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库存盘点对象 stocktakes
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public class Stocktakes extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 盘点单号 隐藏，根据id同步生成值 */
    @Excel(name = "盘点单号 隐藏，根据id同步生成值")
    private String stocktakeId;

    /** 盘点类型1-全面盘点 2-循环盘点 3-指定物料盘点 暂无用，默认1 */
    @Excel(name = "盘点类型1-全面盘点 2-循环盘点 3-指定物料盘点 暂无用，默认1")
    private String stocktakeType;

    /** 仓库ID 暂无用 */
    @Excel(name = "仓库ID 暂无用")
    private String warehouseId;

    /** 盘点状态1-盘点中 2-已完成 字典，检索条件 */
    @Excel(name = "盘点状态1-盘点中 2-已完成 字典，检索条件")
    private String stocktakeStatus;

    /** 计划日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedDate;

    /** 盘点物料范围 暂时无用 */
    @Excel(name = "盘点物料范围 暂时无用")
    private String materialRange;

    /** 盘点库位范围 暂时无用 */
    @Excel(name = "盘点库位范围 暂时无用")
    private String locationRange;

    /** 总差异金额 暂时无用 */
    @Excel(name = "总差异金额 暂时无用")
    private Long totalVarianceAmount;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    /** 盘点单明细信息 */
    private List<StocktakeItems> stocktakeItemsList;

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }

    public void setStocktakeId(String stocktakeId)
    {
        this.stocktakeId = stocktakeId;
    }

    public String getStocktakeId()
    {
        return stocktakeId;
    }

    public void setStocktakeType(String stocktakeType)
    {
        this.stocktakeType = stocktakeType;
    }

    public String getStocktakeType()
    {
        return stocktakeType;
    }

    public void setWarehouseId(String warehouseId)
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId()
    {
        return warehouseId;
    }

    public void setStocktakeStatus(String stocktakeStatus)
    {
        this.stocktakeStatus = stocktakeStatus;
    }

    public String getStocktakeStatus()
    {
        return stocktakeStatus;
    }

    public void setPlannedDate(Date plannedDate)
    {
        this.plannedDate = plannedDate;
    }

    public Date getPlannedDate()
    {
        return plannedDate;
    }

    public void setMaterialRange(String materialRange)
    {
        this.materialRange = materialRange;
    }

    public String getMaterialRange()
    {
        return materialRange;
    }

    public void setLocationRange(String locationRange)
    {
        this.locationRange = locationRange;
    }

    public String getLocationRange()
    {
        return locationRange;
    }

    public void setTotalVarianceAmount(Long totalVarianceAmount)
    {
        this.totalVarianceAmount = totalVarianceAmount;
    }

    public Long getTotalVarianceAmount()
    {
        return totalVarianceAmount;
    }

    public void setIsUsed(Long isUsed)
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed()
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo)
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo()
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode)
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode()
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode)
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode()
    {
        return updateUserCode;
    }

    public List<StocktakeItems> getStocktakeItemsList()
    {
        return stocktakeItemsList;
    }

    public void setStocktakeItemsList(List<StocktakeItems> stocktakeItemsList)
    {
        this.stocktakeItemsList = stocktakeItemsList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("stocktakeId", getStocktakeId())
            .append("stocktakeType", getStocktakeType())
            .append("warehouseId", getWarehouseId())
            .append("stocktakeStatus", getStocktakeStatus())
            .append("plannedDate", getPlannedDate())
            .append("materialRange", getMaterialRange())
            .append("locationRange", getLocationRange())
            .append("totalVarianceAmount", getTotalVarianceAmount())
            .append("remark", getRemark())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .append("stocktakeItemsList", getStocktakeItemsList())
            .toString();
    }
}
