package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.OutboundOrderLog;

/**
 * 出库明细子（仅用于锁定数量统计）Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IOutboundOrderLogService 
{
    /**
     * 查询出库明细子（仅用于锁定数量统计）
     * 
     * @param id 出库明细子（仅用于锁定数量统计）主键
     * @return 出库明细子（仅用于锁定数量统计）
     */
    public OutboundOrderLog selectOutboundOrderLogById(String id);

    /**
     * 查询出库明细子（仅用于锁定数量统计）列表
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 出库明细子（仅用于锁定数量统计）集合
     */
    public List<OutboundOrderLog> selectOutboundOrderLogList(OutboundOrderLog outboundOrderLog);

    /**
     * 新增出库明细子（仅用于锁定数量统计）
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 结果
     */
    public int insertOutboundOrderLog(OutboundOrderLog outboundOrderLog);

    Long selectLockedQuantity(OutboundOrderLog outboundOrderLog);

    /**
     * 修改出库明细子（仅用于锁定数量统计）
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 结果
     */
    public int updateOutboundOrderLog(OutboundOrderLog outboundOrderLog);

    /**
     * 批量删除出库明细子（仅用于锁定数量统计）
     * 
     * @param ids 需要删除的出库明细子（仅用于锁定数量统计）主键集合
     * @return 结果
     */
    public int deleteOutboundOrderLogByIds(String[] ids);

    /**
     * 删除出库明细子（仅用于锁定数量统计）信息
     * 
     * @param id 出库明细子（仅用于锁定数量统计）主键
     * @return 结果
     */
    public int deleteOutboundOrderLogById(String id);
}
