package com.ruoyi.common.core.domain;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ruoyi.common.constant.UserConstants;
import com.ruoyi.common.core.domain.entity.MaterialsCategory;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.core.domain.entity.Materials;
import com.ruoyi.common.utils.StringUtils;

/**
 * Treeselect树结构实体类
 * 
 * @author ruoyi
 */
public class TreeSelect implements Serializable
{
    private static final long serialVersionUID = 1L;

    /** 节点ID */
    private String id;

    /** String节点ID */
    private String sid;
    /** 节点名称 */
    private String label;

    /** 节点禁用 */
    private boolean disabled = false;

    /** 子节点 */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<TreeSelect> children;
    
    /** 物料列表 */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Materials> materials;

    public TreeSelect()
    {

    }

    public TreeSelect(SysDept dept)
    {
        this.id = String.valueOf(dept.getDeptId());
        this.label = dept.getDeptName();
        this.disabled = StringUtils.equals(UserConstants.DEPT_DISABLE, dept.getStatus());
        this.children = dept.getChildren().stream().map(TreeSelect::new).collect(Collectors.toList());
    }
    public TreeSelect(MaterialsCategory materialsCategory){
        this.sid = materialsCategory.getId();
        this.label = materialsCategory.getCategoryName();
        this.disabled = StringUtils.equals(String.valueOf(0), String.valueOf(materialsCategory.getIsUsed()));
        this.children = materialsCategory.getChildren().stream().map(TreeSelect::new).collect(Collectors.toList());
    }
    public TreeSelect(SysMenu menu)
    {
        this.id = String.valueOf(menu.getMenuId());
        this.label = menu.getMenuName();
        this.children = menu.getChildren().stream().map(TreeSelect::new).collect(Collectors.toList());
    }
    
    /**
     * 带物料的构造函数
     */
    public TreeSelect(MaterialsCategory materialsCategory, List<Materials> materialsList){
        this.sid = materialsCategory.getId();
        this.label = materialsCategory.getCategoryName();
        this.disabled = StringUtils.equals(String.valueOf(0), String.valueOf(materialsCategory.getIsUsed()));
        this.children = materialsCategory.getChildren().stream().map(TreeSelect::new).collect(Collectors.toList());
        this.materials = materialsList;
    }

    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public String getLabel()
    {
        return label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public boolean isDisabled()
    {
        return disabled;
    }

    public void setDisabled(boolean disabled)
    {
        this.disabled = disabled;
    }

    public List<TreeSelect> getChildren()
    {
        return children;
    }

    public void setChildren(List<TreeSelect> children)
    {
        this.children = children;
    }

    public String getSid() {
        return sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public List<Materials> getMaterials() {
        return materials;
    }

    public void setMaterials(List<Materials> materials) {
        this.materials = materials;
    }
}
