package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.StorageLocationsCategory;

/**
 * 库位存放分类Service接口
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
public interface IStorageLocationsCategoryService 
{
    /**
     * 查询库位存放分类
     * 
     * @param id 库位存放分类主键
     * @return 库位存放分类
     */
    public StorageLocationsCategory selectStorageLocationsCategoryById(String id);

    /**
     * 查询库位存放分类列表
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 库位存放分类集合
     */
    public List<StorageLocationsCategory> selectStorageLocationsCategoryList(StorageLocationsCategory storageLocationsCategory);

    /**
     * 新增库位存放分类
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 结果
     */
    public int insertStorageLocationsCategory(StorageLocationsCategory storageLocationsCategory);

    /**
     * 修改库位存放分类
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 结果
     */
    public int updateStorageLocationsCategory(StorageLocationsCategory storageLocationsCategory);

    /**
     * 批量删除库位存放分类
     * 
     * @param ids 需要删除的库位存放分类主键集合
     * @return 结果
     */
    public int deleteStorageLocationsCategoryByIds(String[] ids);

    /**
     * 删除库位存放分类信息
     * 
     * @param id 库位存放分类主键
     * @return 结果
     */
    public int deleteStorageLocationsCategoryById(String id);
}
