package com.ruoyi.inventory.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 入库单明细对象 inbound_order_items
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public class InboundOrderItems extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 关联主表ID */
    private String inboundOrderId;

    /** 入库单号 检索条件 */
    @Excel(name = "入库单号")
    private String orderId;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "货物ID")
    private String materialId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID")
    private String batchId;

    /** 仓库ID 检索条件 */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 库位ID 检索条件 */
    @Excel(name = "库位ID")
    private String locationId;

    /** 收获库位 检索条件 */
    private String receiptLocationId;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Long actualQuantity;

    /** 计划件数 暂无用 */
    @Excel(name = "计划件数")
    private Long plannedPackages;

    /** 实际件数 */
    @Excel(name = "实际件数")
    private Long actualPackages;

    /** 约数 */
//    @Excel(name = "约数")
    private Long divisor;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色")
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号")
    private String voucherNumber;

    /** 单价 */
    @Excel(name = "单价")
    private Double unitPrice;

    /** 状态1-待收货 2-部分收货 3-已完成 暂无用 */
//    @Excel(name = "状态")
    private Long itemStatus;

    /** 收货时间 暂无用 */
    @Excel(name = "收货时间")
    private Long receivedAt;

    /** 收货人 */
    @Excel(name = "收货人")
    private String receivedBy;

    /** 贴标数量 */
    private Long labelQuantity;

    /** 应用数据1使用0删除 删除用 */
//    @Excel(name = "应用数据")
    private Long isUsed;

    /** 排序 */
//    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
//    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
//    @Excel(name = "排序号")
    private String updateUserCode;
    /** 单件重量 */
    private Double packageWeight;
    /** 单位重量 */
    private Double unitWeight;

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId()
    {
        return orderId;
    }

    public void setMaterialId(String materialId)
    {
        this.materialId = materialId;
    }

    public String getMaterialId()
    {
        return materialId;
    }

    public void setBatchId(String batchId)
    {
        this.batchId = batchId;
    }

    public String getBatchId()
    {
        return batchId;
    }

    public void setWarehouseId(String warehouseId)
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId()
    {
        return warehouseId;
    }

    public void setLocationId(String locationId)
    {
        this.locationId = locationId;
    }

    public String getLocationId()
    {
        return locationId;
    }

    public void setPlannedQuantity(Long plannedQuantity)
    {
        this.plannedQuantity = plannedQuantity;
    }

    public Long getPlannedQuantity()
    {
        return plannedQuantity;
    }

    public void setActualQuantity(Long actualQuantity)
    {
        this.actualQuantity = actualQuantity;
    }

    public Long getActualQuantity()
    {
        return actualQuantity;
    }

    public void setPlannedPackages(Long plannedPackages)
    {
        this.plannedPackages = plannedPackages;
    }

    public Long getPlannedPackages()
    {
        return plannedPackages;
    }

    public void setActualPackages(Long actualPackages)
    {
        this.actualPackages = actualPackages;
    }

    public Long getActualPackages()
    {
        return actualPackages;
    }

    public void setDivisor(Long divisor)
    {
        this.divisor = divisor;
    }

    public Long getDivisor()
    {
        return divisor;
    }

    public void setLabelColor(Long labelColor)
    {
        this.labelColor = labelColor;
    }

    public Long getLabelColor()
    {
        return labelColor;
    }

    public void setVoucherNumber(String voucherNumber)
    {
        this.voucherNumber = voucherNumber;
    }

    public String getVoucherNumber()
    {
        return voucherNumber;
    }

    public Double getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setItemStatus(Long itemStatus)
    {
        this.itemStatus = itemStatus;
    }

    public Long getItemStatus()
    {
        return itemStatus;
    }

    public void setReceivedAt(Long receivedAt)
    {
        this.receivedAt = receivedAt;
    }

    public Long getReceivedAt()
    {
        return receivedAt;
    }

    public void setReceivedBy(String receivedBy)
    {
        this.receivedBy = receivedBy;
    }

    public String getReceivedBy()
    {
        return receivedBy;
    }

    public void setIsUsed(Long isUsed)
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed()
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo)
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo()
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode)
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode()
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode)
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode()
    {
        return updateUserCode;
    }

    public String getInboundOrderId() {
        return inboundOrderId;
    }

    public void setInboundOrderId(String inboundOrderId) {
        this.inboundOrderId = inboundOrderId;
    }

    public String getReceiptLocationId() {
        return receiptLocationId;
    }

    public void setReceiptLocationId(String receiptLocationId) {
        this.receiptLocationId = receiptLocationId;
    }

    public Long getLabelQuantity() {
        return labelQuantity;
    }

    public void setLabelQuantity(Long labelQuantity) {
        this.labelQuantity = labelQuantity;
    }

    public Double getUnitWeight() {
        return unitWeight;
    }

    public void setUnitWeight(Double unitWeight) {
        this.unitWeight = unitWeight;
    }

    public Double getPackageWeight() {
        return packageWeight;
    }

    public void setPackageWeight(Double packageWeight) {
        this.packageWeight = packageWeight;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("orderId", getOrderId())
                .append("materialId", getMaterialId())
                .append("batchId", getBatchId())
                .append("warehouseId", getWarehouseId())
                .append("locationId", getLocationId())
                .append("plannedQuantity", getPlannedQuantity())
                .append("actualQuantity", getActualQuantity())
                .append("plannedPackages", getPlannedPackages())
                .append("actualPackages", getActualPackages())
                .append("divisor", getDivisor())
                .append("labelColor", getLabelColor())
                .append("voucherNumber", getVoucherNumber())
                .append("unitPrice", getUnitPrice())
                .append("itemStatus", getItemStatus())
                .append("receivedAt", getReceivedAt())
                .append("receivedBy", getReceivedBy())
                .append("remark", getRemark())
                .append("isUsed", getIsUsed())
                .append("sortNo", getSortNo())
                .append("createTime", getCreateTime())
                .append("createUserCode", getCreateUserCode())
                .append("updateTime", getUpdateTime())
                .append("updateUserCode", getUpdateUserCode())
                .append("inboundOrderId", getInboundOrderId())
                .append("receiptLocationId", getReceiptLocationId())
                .append("labelQuantity", getLabelQuantity())
                .toString();
    }
}
