package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.OutboundOrders;
import com.ruoyi.inventory.domain.OutboundOrderItems;

/**
 * 出库单主Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface OutboundOrdersMapper 
{
    /**
     * 查询出库单主
     * 
     * @param id 出库单主主键
     * @return 出库单主
     */
    public OutboundOrders selectOutboundOrdersById(String id);

    /**
     * 查询出库单主列表
     * 
     * @param outboundOrders 出库单主
     * @return 出库单主集合
     */
    public List<OutboundOrders> selectOutboundOrdersList(OutboundOrders outboundOrders);

    /**
     * 新增出库单主
     * 
     * @param outboundOrders 出库单主
     * @return 结果
     */
    public int insertOutboundOrders(OutboundOrders outboundOrders);

    /**
     * 修改出库单主
     * 
     * @param outboundOrders 出库单主
     * @return 结果
     */
    public int updateOutboundOrders(OutboundOrders outboundOrders);

    /**
     * 删除出库单主
     * 
     * @param id 出库单主主键
     * @return 结果
     */
    public int deleteOutboundOrdersById(String id);

    /**
     * 批量删除出库单主
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOutboundOrdersByIds(String[] ids);

    /**
     * 批量删除出库单明细
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOutboundOrderItemsByOrderIds(String[] ids);
    
    /**
     * 批量新增出库单明细
     * 
     * @param outboundOrderItemsList 出库单明细列表
     * @return 结果
     */
    public int batchOutboundOrderItems(List<OutboundOrderItems> outboundOrderItemsList);
    

    /**
     * 通过出库单主主键删除出库单明细信息
     * 
     * @param id 出库单主ID
     * @return 结果
     */
    public int deleteOutboundOrderItemsByOrderId(String id);
}
