package com.ruoyi.inventory.service;

import java.util.List;

import com.ruoyi.common.annotation.SerialExecution;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.inventory.domain.Inventory;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.domain.StocktakeItems;

/**
 * 库存Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IInventoryService 
{
    /**
     * 查询库存
     * 
     * @param id 库存主键
     * @return 库存
     */
    public Inventory selectInventoryById(String id);

    /**
     * 查询库存列表
     * 
     * @param inventory 库存
     * @return 库存集合
     */
    public List<Inventory> selectInventoryList(Inventory inventory);

    Inventory selectInventory(Inventory inventory);

    /**
     * 新增库存
     * 
     * @param inventory 库存
     * @return 结果
     */
    public int insertInventory(Inventory inventory);

    /**
     * 批量新增库存
     *
     * @param inventoryList 库存
     * @return 结果
     */
    public int insertInventoryList(List<Inventory> inventoryList);
    /**
     * 修改库存
     * 
     * @param inventory 库存
     * @return 结果
     */
    public int updateInventory(Inventory inventory);

    int RefreshInventory(List<String> inventoryIds);

    @SerialExecution(group = "inventoryRefresh", fair = true)
    int ship(List<OutboundOrderItems> outboundOrderItems);

    @SerialExecution(group = "inventoryRefresh", fair = true)
    boolean inventoryLockValidation(List<OutboundOrderItems> outboundOrderItems);

    /**
     * 批量删除库存
     * 
     * @param ids 需要删除的库存主键集合
     * @return 结果
     */
    public int deleteInventoryByIds(String[] ids);

    /**
     * 删除库存信息
     * 
     * @param id 库存主键
     * @return 结果
     */
    public int deleteInventoryById(String id);

    public List<Inventory> listByMatreialId(String materialId);
    /**
     * @description: 获取库存盘点详细信息
     * @author cs
     * @date 2025/12/3
     * @version 1.0
     */
    public List<StocktakeItems> selectstocktakeItemsList();

    /**
     * 按物料汇总统计库存
     * 
     * @param inventory 库存查询条件
     * @return 库存汇总统计集合
     */
    public List<com.ruoyi.inventory.domain.vo.InventorySummaryVO> selectInventorySummaryList(Inventory inventory);

    /**
     * 查询库存明细列表（根据物料标识及检索条件）
     * 
     * @param inventory 库存查询条件
     * @return 库存明细集合
     */
    public List<Inventory> selectInventoryDetailList(Inventory inventory);
}
