package com.ruoyi.inventory.mapper;

import java.util.List;

import com.ruoyi.inventory.domain.InboundOrderItems;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.domain.vo.OutboundOrdersSummaryVO;

/**
 * 出库单明细Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface OutboundOrderItemsMapper 
{
    /**
     * 查询出库单明细
     * 
     * @param id 出库单明细主键
     * @return 出库单明细
     */
    public OutboundOrderItems selectOutboundOrderItemsById(String id);

    /**
     * 查询出库单明细列表
     * 
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细集合
     */
    public List<OutboundOrderItems> selectOutboundOrderItemsList(OutboundOrderItems outboundOrderItems);

    /**
     * 查询出库单明细统计
     *
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细集合
     */
    public List<OutboundOrdersSummaryVO> selectOutboundOrderItemsStatistics(OutboundOrdersSummaryVO outboundOrderItems);

    public List<OutboundOrderItems> selectOutboundOrderItemsStatisticsList(OutboundOrderItems outboundOrderItems);
    /**
     * 新增出库单明细
     * 
     * @param outboundOrderItems 出库单明细
     * @return 结果
     */
    public int insertOutboundOrderItems(OutboundOrderItems outboundOrderItems);

    /**
     * 修改出库单明细
     * 
     * @param outboundOrderItems 出库单明细
     * @return 结果
     */
    public int updateOutboundOrderItems(OutboundOrderItems outboundOrderItems);

    /**
     * 删除出库单明细
     * 
     * @param id 出库单明细主键
     * @return 结果
     */
    public int deleteOutboundOrderItemsById(String id);

    /**
     * 批量删除出库单明细
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOutboundOrderItemsById(String[] ids);


    public int batchInsertOutboundOrderItems(List<OutboundOrderItems> inboundOrderItems);


}
