import request from '@/utils/request'

// 查询入库列表
export function listInbound(query) {
  return request({
    url: '/inventory/inbound/list',
    method: 'get',
    params: query
  })
}

// 查询入库详细
export function getInbound(id) {
  return request({
    url: '/inventory/inbound/' + id,
    method: 'get'
  })
}

// 新增入库
export function addInbound(data) {
  return request({
    url: '/inventory/inbound',
    method: 'post',
    data: data
  })
}

// 修改入库
export function updateInbound(data) {
  return request({
    url: '/inventory/inbound',
    method: 'put',
    data: data
  })
}

// 删除入库
export function delInbound(id) {
  return request({
    url: '/inventory/inbound/' + id,
    method: 'delete'
  })
}
