package com.ruoyi.common.core.domain.entity;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import com.ruoyi.common.core.domain.entity.Materials;

import java.util.ArrayList;
import java.util.List;

/**
 * 物料分类对象 materials_category
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public class MaterialsCategory extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */

    private String id;

    /** 物料编码 检索条件 */
    @Excel(name = "物料编码 检索条件")
    private String categoryCode;

    /** 物料名称 检索条件 */
    @Excel(name = "物料名称 检索条件")
    private String categoryName;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    @Excel(name = "父级Code")
    private String parentId;

    @Excel(name = "使用状态")
    private int isUsed;

    private String parentName;

    private List<MaterialsCategory> children = new ArrayList<MaterialsCategory>();
    
    /** 分类下的物料列表 */
    private List<Materials> materialsList = new ArrayList<Materials>();
    
    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setCategoryCode(String categoryCode) 
    {
        this.categoryCode = categoryCode;
    }

    public String getCategoryCode() 
    {
        return categoryCode;
    }

    public void setCategoryName(String categoryName) 
    {
        this.categoryName = categoryName;
    }

    public String getCategoryName() 
    {
        return categoryName;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public int getIsUsed() {
        return isUsed;
    }

    public void setIsUsed(int isUsed) {
        this.isUsed = isUsed;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public List<MaterialsCategory> getChildren() {
        return children;
    }

    public void setChildren(List<MaterialsCategory> children) {
        this.children = children;
    }

    public List<Materials> getMaterialsList() {
        return materialsList;
    }

    public void setMaterialsList(List<Materials> materialsList) {
        this.materialsList = materialsList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("categoryCode", getCategoryCode())
                .append("categoryName", getCategoryName())
                .append("sortNo", getSortNo())
                .append("createTime", getCreateTime())
                .append("createUserCode", getCreateUserCode())
                .append("updateTime", getUpdateTime())
                .append("updateUserCode", getUpdateUserCode())
                .append("parentId", getParentId())
                .append("isUsed", getIsUsed())
                .append("parentName", getParentName())
                .append("children", getChildren())
                .append("materialsList", getMaterialsList())
                .toString();
    }
}
