package com.ruoyi.inventory.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 出库明细子（仅用于锁定数量统计）对象 outbound_order_log
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public class OutboundOrderLog extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 明细ID（主键） */
    private String id;

    /** 货物ID */
    @Excel(name = "出货单号ID")
    private String orderId;

    /** 货物ID */
    @Excel(name = "货物ID")
    private String materialId;

    /** 仓库ID */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 批次ID */
    @Excel(name = "批次ID")
    private String batchCode;

    /** 实际入库数量 */
    @Excel(name = "实际入库数量")
    private Long actualQuantity;

    /** 明细状态：1-待入库/2-部分入库/3-已完成 */
    @Excel(name = "明细状态：1-待入库/2-部分入库/3-已完成")
    private Long itemStatus;

    /** 数据状态：1-有效/0-删除 */
    @Excel(name = "数据状态：1-有效/0-删除")
    private Long isUsed;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setMaterialId(String materialId) 
    {
        this.materialId = materialId;
    }

    public String getMaterialId() 
    {
        return materialId;
    }

    public void setWarehouseId(String warehouseId) 
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId() 
    {
        return warehouseId;
    }

    public void setBatchCode(String batchCode) 
    {
        this.batchCode = batchCode;
    }

    public String getBatchCode() 
    {
        return batchCode;
    }




    public void setActualQuantity(Long actualQuantity) 
    {
        this.actualQuantity = actualQuantity;
    }

    public Long getActualQuantity() 
    {
        return actualQuantity;
    }

    public void setItemStatus(Long itemStatus) 
    {
        this.itemStatus = itemStatus;
    }

    public Long getItemStatus() 
    {
        return itemStatus;
    }

    public void setIsUsed(Long isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed() 
    {
        return isUsed;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("orderId", getOrderId())
            .append("materialId", getMaterialId())
            .append("warehouseId", getWarehouseId())
            .append("batchCode", getBatchCode())
            .append("actualQuantity", getActualQuantity())
            .append("itemStatus", getItemStatus())
            .append("isUsed", getIsUsed())
            .toString();
    }
}
