package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.inventory.domain.TO.OutboundOrderItemsStatisticsVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.OutboundOrderItemsMapper;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.service.IOutboundOrderItemsService;

/**
 * 出库单明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@Service
public class OutboundOrderItemsServiceImpl implements IOutboundOrderItemsService 
{
    @Autowired
    private OutboundOrderItemsMapper outboundOrderItemsMapper;

    @Autowired
    private InventoryServiceImpl inventoryService;

    @Autowired
    private OutboundOrderLogServiceImpl outboundOrderLogService;
    /**
     * 查询出库单明细
     * 
     * @param id 出库单明细主键
     * @return 出库单明细
     */
    @Override
    public OutboundOrderItems selectOutboundOrderItemsById(String id)
    {
        return outboundOrderItemsMapper.selectOutboundOrderItemsById(id);
    }

    /**
     * 查询出库单明细列表
     * 
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细
     */
    @Override
    public List<OutboundOrderItems> selectOutboundOrderItemsList(OutboundOrderItems outboundOrderItems)
    {
        return outboundOrderItemsMapper.selectOutboundOrderItemsList(outboundOrderItems);
    }

    @Override
    public List<OutboundOrderItems> selectOutboundOrderItemsStatistics(OutboundOrderItemsStatisticsVO outboundOrderItems) {
        List<OutboundOrderItems> list = outboundOrderItemsMapper.selectOutboundOrderItemsStatistics(outboundOrderItems);
        return list;
    }


    @Override
    public int insertOutboundOrderItems(OutboundOrderItems outboundOrderItems)
    {
        outboundOrderItems.setCreateTime(DateUtils.getNowDate());
        return outboundOrderItemsMapper.insertOutboundOrderItems(outboundOrderItems);
    }


    @Override
    public int updateOutboundOrderItems(OutboundOrderItems outboundOrderItems)
    {
        outboundOrderItems.setUpdateTime(DateUtils.getNowDate());
        return outboundOrderItemsMapper.updateOutboundOrderItems(outboundOrderItems);
    }

    /**
     * 批量删除出库单明细
     * 
     * @param ids 需要删除的出库单明细主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderItemsByIds(String[] ids)
    {
        return outboundOrderItemsMapper.deleteOutboundOrderItemsByIds(ids);
    }

    /**
     * 删除出库单明细信息
     * 
     * @param id 出库单明细主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderItemsById(String id)
    {
        return outboundOrderItemsMapper.deleteOutboundOrderItemsById(id);
    }
}
