package com.ruoyi.inventory.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.inventory.domain.TO.StocktakesTO;
import com.ruoyi.inventory.domain.TO.StocktakesVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.Stocktakes;
import com.ruoyi.inventory.service.IStocktakesService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 库存盘点Controller
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@RestController
@RequestMapping("/inventory/stocktakes")
public class StocktakesController extends BaseController
{
    @Autowired
    private IStocktakesService stocktakesService;

    /**
     * 查询库存盘点列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:list')")
    @GetMapping("/list")
    public TableDataInfo list(Stocktakes stocktakes)
    {
        startPage();
        List<Stocktakes> list = stocktakesService.selectStocktakesList(stocktakes);
        return getDataTable(list);
    }

    /**
     * 导出库存盘点列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:export')")
    @Log(title = "库存盘点", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Stocktakes stocktakes)
    {
        List<Stocktakes> list = stocktakesService.selectStocktakesList(stocktakes);
        ExcelUtil<Stocktakes> util = new ExcelUtil<Stocktakes>(Stocktakes.class);
        util.exportExcel(response, list, "库存盘点数据");
    }

    /**
     * 获取库存盘点详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:query')")
    @GetMapping(value = "/")
    public AjaxResult getInfo(@RequestParam("id") String id,
     @RequestParam(required = false) String operationType)
    {
        return success(stocktakesService.selectStocktakesById(id,operationType));
    }

    /**
     * 新增库存盘点
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:add')")
    @Log(title = "库存盘点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Stocktakes stocktakes)
    {
        return toAjax(stocktakesService.insertStocktakes(stocktakes));
    }

    /**
     * 修改库存盘点
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:edit')")
    @Log(title = "库存盘点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody StocktakesTO stocktakes)
    {
        return toAjax(stocktakesService.updateStocktakes(stocktakes));
    }

    /**
     * 删除库存盘点
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:remove')")
    @Log(title = "库存盘点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(stocktakesService.deleteStocktakesByIds(ids));
    }

    /**
     * @description: 查询处理统计
     * @author cs
     * @date 2025/12/8
     * @version 1.0
     */
    @GetMapping("/listCount")
    public TableDataInfo listCount(StocktakesVo stocktakes)
    {
        startPage();
        List<StocktakesVo> list = stocktakesService.selectStocktakesListCount(stocktakes);
        return getDataTable(list);
    }
    /**
     * @description: 查询处理统计-详情
     * @author cs
     * @date 2025/12/9
     * @version 1.0
     */
    @GetMapping("/countInfo")
    public TableDataInfo countInfo(StocktakesVo stocktakes)
    {
        startPage();
        List<StocktakesVo> list = stocktakesService.selectStocktakesCountInfo(stocktakes);
        return getDataTable(list);
    }

    /**
     * @description: 首页-本月盘点次数
     * @author cs
     * @date 2025/12/10
     * @version 1.0
     */
    @GetMapping(value = "/countStocktakes")
    public AjaxResult countStocktakes()
    {
        return success(stocktakesService.selectStocktakesCountByMonth());
    }
}
