package com.ruoyi.inventory.service.impl;

import java.util.ArrayList;
import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.inventory.domain.Inventory;
import com.ruoyi.inventory.domain.OutboundOrderItemsInventory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.OutboundOrderItemsMapper;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.service.IOutboundOrderItemsService;

/**
 * 出库单明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@Service
public class OutboundOrderItemsServiceImpl implements IOutboundOrderItemsService 
{
    @Autowired
    private OutboundOrderItemsMapper outboundOrderItemsMapper;

    @Autowired
    private InventoryServiceImpl inventoryService;
    /**
     * 查询出库单明细
     * 
     * @param id 出库单明细主键
     * @return 出库单明细
     */
    @Override
    public OutboundOrderItemsInventory selectOutboundOrderItemsById(String id)
    {
        OutboundOrderItems outboundOrderItems = outboundOrderItemsMapper.selectOutboundOrderItemsById(id);
        Inventory inventory = new Inventory();
        BeanUtils.copyProperties(outboundOrderItems, inventory);
        Inventory inventory1 = inventoryService.selectInventory(inventory);
        OutboundOrderItemsInventory outboundOrderItemsInventory = new OutboundOrderItemsInventory();
        outboundOrderItemsInventory.setOutboundOrderItems(outboundOrderItems);
        outboundOrderItemsInventory.setInventory(inventory1);
        return outboundOrderItemsInventory;
    }

    /**
     * 查询出库单明细列表
     * 
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细
     */
    @Override
    public List<OutboundOrderItemsInventory> selectOutboundOrderItemsList(OutboundOrderItems outboundOrderItems)
    {
        List<OutboundOrderItems> itemsList = outboundOrderItemsMapper.selectOutboundOrderItemsList(outboundOrderItems);
        List<OutboundOrderItemsInventory> resultList = new ArrayList<>();
        for (OutboundOrderItems item : itemsList) {
            Inventory inventory = new Inventory();
            BeanUtils.copyProperties(item, inventory);
            Inventory inventory1 = inventoryService.selectInventory(inventory);
            OutboundOrderItemsInventory outboundOrderItemsInventory = new OutboundOrderItemsInventory();
            outboundOrderItemsInventory.setOutboundOrderItems(item);
            outboundOrderItemsInventory.setInventory(inventory1);
            resultList.add(outboundOrderItemsInventory);
        }
        return resultList;
    }

    /**
     * 新增出库单明细
     * 
     * @param outboundOrderItems 出库单明细
     * @return 结果
     */
    @Override
    public int insertOutboundOrderItems(OutboundOrderItems outboundOrderItems)
    {
        outboundOrderItems.setCreateTime(DateUtils.getNowDate());
        return outboundOrderItemsMapper.insertOutboundOrderItems(outboundOrderItems);
    }

    /**
     * 修改出库单明细
     * 
     * @param outboundOrderItems 出库单明细
     * @return 结果
     */
    @Override
    public int updateOutboundOrderItems(OutboundOrderItems outboundOrderItems)
    {
        outboundOrderItems.setUpdateTime(DateUtils.getNowDate());
        return outboundOrderItemsMapper.updateOutboundOrderItems(outboundOrderItems);
    }

    /**
     * 批量删除出库单明细
     * 
     * @param ids 需要删除的出库单明细主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderItemsByIds(String[] ids)
    {
        return outboundOrderItemsMapper.deleteOutboundOrderItemsByIds(ids);
    }

    /**
     * 删除出库单明细信息
     * 
     * @param id 出库单明细主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderItemsById(String id)
    {
        return outboundOrderItemsMapper.deleteOutboundOrderItemsById(id);
    }
}
