package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 出入库统计视图对象
 * 按物料汇总入库/出库次数、数量及金额
 */
@Data
public class InboundOutboundStatisticsVO extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** 物料ID */
//    @Excel(name = "物料ID")
    private String materialId;

    /** 物料名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** 入库次数 */
    @Excel(name = "入库次数")
    private Integer inboundCount;

    /** 出库次数 */
    @Excel(name = "出库次数")
    private Integer outboundCount;

    /** 入库数量 */
    @Excel(name = "入库数量")
    private BigDecimal inboundQuantity;

    /** 出库数量 */
    @Excel(name = "出库数量")
    private BigDecimal outboundQuantity;

    /** 入库总额 */
    @Excel(name = "入库总额")
    private BigDecimal inboundAmount;

    /** 出库总额 */
    @Excel(name = "出库总额")
    private BigDecimal outboundAmount;

    /** 金额差（入库-出库） */
    @Excel(name = "总额差")
    private BigDecimal amountDiff;

    /** 开始日期（主表日期过滤） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /** 结束日期（主表日期过滤） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /** 仓库ID */
    private String warehouseId;

    /** 仓库编码（支持模糊） */
    private String warehousesCode;

    /** 库位ID */
    private String locationId;
    /** 物料编码/ID查询 */
    private String materialCode;


}

