package com.ruoyi.inventory.utils;

import com.ruoyi.inventory.domain.Inventory;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 库存映射全局缓存（解决导入新增库存即时可见问题）
 */
public class InventoryCache {
    // 并发安全Map，Key=物料ID_库位ID_库存类型，Value=库存对象
    private static final Map<String, Inventory> INVENTORY_MAP = new ConcurrentHashMap<>();

    // 添加库存（直接存对象，避免参数不匹配）
    public static void addInventory(String key, Inventory inventory) {
        INVENTORY_MAP.put(key, inventory);
    }

    // 获取库存
    public static Inventory getInventory(String key) {
        return INVENTORY_MAP.get(key);
    }

    // 清空缓存
    public static void clear() {
        INVENTORY_MAP.clear();
    }

    // 获取全部缓存（核心：供loadInventoryGroupMap直接读取）
    public static Map<String, Inventory> getAll() {
        return INVENTORY_MAP;
    }

}