package com.ruoyi.inventory.domain.vo.inboundVO;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;
@Data
public class InboundTRDCTemplateVO extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /** 编号 */
    private String id;

    /** 入库日期 日期无时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundDate;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "SAP No")
    private String sapNo;

    /** 货物名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** 货物名称 */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 批次ID 检索条件 */
    @Excel(name = "批号")
    private String batchId;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    @Excel(name = "件重")
    private Double unitWeight;

    /** 约数 */
    @Excel(name = "约数")
    private Long divisor;

    /** 实际件数 */
    @Excel(name = "件数")
    private Long actualPackages;

    /** 实际数量 */
    @Excel(name = "实发数量")
    private Long actualQuantity;

    /** 库位ID 检索条件 */
    @Excel(name = "库位")
    private String locationId;

    /** 仓库ID 暂无用 */
    @Excel(name = "仓库")
    private String warehouseId;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 库位ID 检索条件 */
//    @Excel(name = "收货库位")
    private String relocationId;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色")
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号")
    private String voucherNumber;

    @Excel(name = "保温")
    private String keepWarm;

    @Excel(name = "危险类别")
    private String hazardId;

    /** 入库单号 检索条件 */
    @Excel(name = "单号")
    private String orderId;

    /** 系统编号 检索条件 */
    @Excel(name = "系统编号")
    private String systemNo;

    /** 货主ID */
    @Excel(name = "货主")
    private String ownerId;

    /** 入库类型 字典，检索条件 */
    @Excel(name = "贴标数量")
    private String labelQuantity;

    /** 订单类型 字典，检索条件 */
    @Excel(name = "订单类型")
    private String orderType;

    @Excel(name = "单件重量")
    private Double packageWeight;

    /** 单价 */
//    @Excel(name = "单价")
    private Long unitPrice;

    /** 收货人 */
//    @Excel(name = "收货人")
    private String receivedBy;

    /** 物料备注 */
//    @Excel(name = "物料备注")
    private String remark2;

    /** 负责人 暂无用 */
//    @Excel(name = "负责人 暂无用")
    private String opUserName;

    /** 计划件数 暂无用 */
    //  @Excel(name = "件数")
    private Long plannedPackages;

    /** 排序号 */
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;


    private String updateUserCode;
}
