package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 出库单明细对象 outbound_order_items
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public class OutboundTemplateVO extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 入库单号 检索条件 */
    @Excel(name = "入库单号")
    private String orderId;

    /** 系统编号 检索条件 */
    @Excel(name = "系统编号")
    private String systemNo;

    /** 入库类型 字典，检索条件 */
    @Excel(name = "入库类型")
    private String orderTypeId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID")
    private String batchId;

    /** 入库日期 日期无时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "入库日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundDate;

    /** 订单类型 字典，检索条件 */
    @Excel(name = "订单类型")
    private String orderType;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 货主ID */
    @Excel(name = "货主ID")
    private String ownerId;

    /** 仓库ID 暂无用 */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 库位ID 检索条件 */
    @Excel(name = "库位ID")
    private String locationId;


    /** 货物ID 字典，检索条件 */
    @Excel(name = "SAP号")
    private String sapNo;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "货物名称")
    private String materialName;

    /** 负责人 暂无用 */
//    @Excel(name = "负责人 暂无用")
    private String opUserName;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Long actualQuantity;

    /** 计划件数 暂无用 */
//    @Excel(name = "计划件数")
    private Long plannedPackages;

    /** 实际件数 */
    @Excel(name = "实际件数")
    private Long actualPackages;

    /** 约数 */
    @Excel(name = "约数")
    private Long divisor;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色")
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号")
    private String voucherNumber;

    /** 单价 */
    @Excel(name = "单价")
    private Long unitPrice;

    /** 收货人 */
    @Excel(name = "收货人")
    private String receivedBy;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String remark2;

    /** 排序号 */
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;


    private String updateUserCode;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSystemNo() {
        return systemNo;
    }

    public void setSystemNo(String systemNo) {
        this.systemNo = systemNo;
    }

    public String getOrderTypeId() {
        return orderTypeId;
    }

    public void setOrderTypeId(String orderTypeId) {
        this.orderTypeId = orderTypeId;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Date getInboundDate() {
        return inboundDate;
    }

    public void setInboundDate(Date inboundDate) {
        this.inboundDate = inboundDate;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getRemark2() {
        return remark2;
    }

    public void setRemark2(String remark2) {
        this.remark2 = remark2;
    }

    public String getSapNo() {
        return sapNo;
    }

    public void setSapNo(String sapNo) {
        this.sapNo = sapNo;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getOpUserName() {
        return opUserName;
    }

    public void setOpUserName(String opUserName) {
        this.opUserName = opUserName;
    }

    public Long getPlannedQuantity() {
        return plannedQuantity;
    }

    public void setPlannedQuantity(Long plannedQuantity) {
        this.plannedQuantity = plannedQuantity;
    }

    public Long getActualQuantity() {
        return actualQuantity;
    }

    public void setActualQuantity(Long actualQuantity) {
        this.actualQuantity = actualQuantity;
    }

    public Long getPlannedPackages() {
        return plannedPackages;
    }

    public void setPlannedPackages(Long plannedPackages) {
        this.plannedPackages = plannedPackages;
    }

    public Long getActualPackages() {
        return actualPackages;
    }

    public void setActualPackages(Long actualPackages) {
        this.actualPackages = actualPackages;
    }

    public Long getDivisor() {
        return divisor;
    }

    public void setDivisor(Long divisor) {
        this.divisor = divisor;
    }

    public Long getLabelColor() {
        return labelColor;
    }

    public void setLabelColor(Long labelColor) {
        this.labelColor = labelColor;
    }

    public String getVoucherNumber() {
        return voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public Long getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Long unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getReceivedBy() {
        return receivedBy;
    }

    public void setReceivedBy(String receivedBy) {
        this.receivedBy = receivedBy;
    }

    public String getCreateUserCode() {
        return createUserCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    public String getUpdateUserCode() {
        return updateUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) {
        this.updateUserCode = updateUserCode;
    }

    public Long getSortNo() {
        return sortNo;
    }

    public void setSortNo(Long sortNo) {
        this.sortNo = sortNo;
    }

    @Override
    public String toString() {
        return "InboundTemplateVO{" +
                "id='" + id + '\'' +
                ", orderId='" + orderId + '\'' +
                ", systemNo='" + systemNo + '\'' +
                ", orderTypeId='" + orderTypeId + '\'' +
                ", batchId='" + batchId + '\'' +
                ", inboundDate=" + inboundDate +
                ", orderType='" + orderType + '\'' +
                ", remark1='" + remark + '\'' +
                ", ownerId='" + ownerId + '\'' +
                ", warehouseId='" + warehouseId + '\'' +
                ", locationId='" + locationId + '\'' +
                ", sapNo='" + sapNo + '\'' +
                ", materialName='" + materialName + '\'' +
                ", opUserName='" + opUserName + '\'' +
                ", plannedQuantity=" + plannedQuantity +
                ", actualQuantity=" + actualQuantity +
                ", plannedPackages=" + plannedPackages +
                ", actualPackages=" + actualPackages +
                ", divisor=" + divisor +
                ", labelColor=" + labelColor +
                ", voucherNumber='" + voucherNumber + '\'' +
                ", unitPrice=" + unitPrice +
                ", receivedBy='" + receivedBy + '\'' +
                ", remark2='" + remark2 + '\'' +
                '}';
    }
}
