package com.ruoyi.inventory.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库位对象 storage_locations
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
public class StorageLocations extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 库位编码 检索条件 */
    @Excel(name = "库位编码 检索条件")
    private String locationCode;

    /** 库位名称 检索条件 */
    @Excel(name = "库位名称 检索条件")
    private String locationName;

    /** 仓库编码 检索条件 */
    @Excel(name = "仓库编码 检索条件")
    private String warehousesCode;

    /** 库位类型 1-货架 2-地面 3-货位 4-专区 字典设置，检索条件 */
    @Excel(name = "库位类型 1-货架 2-地面 3-货位 4-专区 字典设置，检索条件")
    private Long locationType;

    /** 区域代码 */
    @Excel(name = "区域代码")
    private String zoneCode;

    /** 排 */
    @Excel(name = "排")
    private String rowCode;

    /** 列 */
    @Excel(name = "列")
    private String columnCode;

    /** 层 文字，检索条件 */
    @Excel(name = "层 文字，检索条件")
    private String layerCode;

    /** 库位容量(千克) */
    @Excel(name = "库位容量(千克)")
    private Long capacity;

    /** 体积容量(立方米) */
    @Excel(name = "体积容量(立方米)")
    private Long volumeCapacity;

    /** 允许存放的危险等级（逗号分隔） */
    @Excel(name = "允许存放的危险等级", readConverterExp = "逗=号分隔")
    private String allowedHazardLevels;

    /** 允许存放的分类ID（逗号分隔） */
    @Excel(name = "允许存放的分类ID", readConverterExp = "逗=号分隔")
    private String allowedCategoryIds;

    /** 允许存放的分类name（前端显示，逗号分隔） */
    private String allowedCategoryNames;

    public String getAllowedCategoryNames() {
        return allowedCategoryNames;
    }

    public void setAllowedCategoryNames(String allowedCategoryNames) {
        this.allowedCategoryNames = allowedCategoryNames;
    }

    /** 温区 */
    @Excel(name = "温区")
    private String temperatureZone;

    /** 应用状态1使用0未使用 */
    @Excel(name = "应用状态1使用0未使用")
    private Long isEnabled;

    /** 应用数据1使用0删除 删除用 */
    private Long isUsed;

    /** 排序 */
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setLocationCode(String locationCode) 
    {
        this.locationCode = locationCode;
    }

    public String getLocationCode() 
    {
        return locationCode;
    }

    public void setLocationName(String locationName) 
    {
        this.locationName = locationName;
    }

    public String getLocationName() 
    {
        return locationName;
    }

    public void setWarehousesCode(String warehousesCode) 
    {
        this.warehousesCode = warehousesCode;
    }

    public String getWarehousesCode() 
    {
        return warehousesCode;
    }

    public void setLocationType(Long locationType) 
    {
        this.locationType = locationType;
    }

    public Long getLocationType() 
    {
        return locationType;
    }

    public void setZoneCode(String zoneCode) 
    {
        this.zoneCode = zoneCode;
    }

    public String getZoneCode() 
    {
        return zoneCode;
    }

    public void setRowCode(String rowCode) 
    {
        this.rowCode = rowCode;
    }

    public String getRowCode() 
    {
        return rowCode;
    }

    public void setColumnCode(String columnCode) 
    {
        this.columnCode = columnCode;
    }

    public String getColumnCode() 
    {
        return columnCode;
    }

    public void setLayerCode(String layerCode) 
    {
        this.layerCode = layerCode;
    }

    public String getLayerCode() 
    {
        return layerCode;
    }

    public void setCapacity(Long capacity) 
    {
        this.capacity = capacity;
    }

    public Long getCapacity() 
    {
        return capacity;
    }

    public void setVolumeCapacity(Long volumeCapacity) 
    {
        this.volumeCapacity = volumeCapacity;
    }

    public Long getVolumeCapacity() 
    {
        return volumeCapacity;
    }

    public void setAllowedHazardLevels(String allowedHazardLevels) 
    {
        this.allowedHazardLevels = allowedHazardLevels;
    }

    public String getAllowedHazardLevels() 
    {
        return allowedHazardLevels;
    }

    public void setAllowedCategoryIds(String allowedCategoryIds) 
    {
        this.allowedCategoryIds = allowedCategoryIds;
    }

    public String getAllowedCategoryIds() 
    {
        return allowedCategoryIds;
    }

    public void setTemperatureZone(String temperatureZone) 
    {
        this.temperatureZone = temperatureZone;
    }

    public String getTemperatureZone() 
    {
        return temperatureZone;
    }

    public void setIsEnabled(Long isEnabled) 
    {
        this.isEnabled = isEnabled;
    }

    public Long getIsEnabled() 
    {
        return isEnabled;
    }

    public void setIsUsed(Long isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed() 
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("locationCode", getLocationCode())
            .append("locationName", getLocationName())
            .append("warehousesCode", getWarehousesCode())
            .append("locationType", getLocationType())
            .append("zoneCode", getZoneCode())
            .append("rowCode", getRowCode())
            .append("columnCode", getColumnCode())
            .append("layerCode", getLayerCode())
            .append("capacity", getCapacity())
            .append("volumeCapacity", getVolumeCapacity())
            .append("allowedHazardLevels", getAllowedHazardLevels())
            .append("allowedCategoryIds", getAllowedCategoryIds())
            .append("temperatureZone", getTemperatureZone())
            .append("isEnabled", getIsEnabled())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
