package com.ruoyi.web.controller.inventory;

import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.inventory.domain.InboundOrderItems;
import com.ruoyi.inventory.domain.vo.InboundDetailsVO;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.service.IInboundOrderItemsService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 入库单明细Controller
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
@RestController
@RequestMapping("/inventory/inbound_items")
public class InboundOrderItemsController extends BaseController
{
    @Autowired
    private IInboundOrderItemsService inboundOrderItemsService;

    /**
     * 查询入库单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:list')")
    @GetMapping("/list")
    public TableDataInfo list(InboundOrderItems inboundOrderItems)
    {
        startPage();
        List<InboundOrderItems> list = inboundOrderItemsService.selectInboundOrderItemsList(inboundOrderItems);
        return getDataTable(list);
    }
    /**
     * 查询入库单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:list')")
    @GetMapping("/listAndMname")
    public TableDataInfo listAndMname(InboundOrderItems inboundOrderItems)
    {
        startPage();
        List<InboundOrderItems> list = inboundOrderItemsService.selectInboundOrderItemsListAndMaterialName(inboundOrderItems);
        return getDataTable(list);
    }

    /**
     * 导出入库单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:export')")
    @Log(title = "入库单明细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, InboundOrderItems inboundOrderItems)
    {
        List<InboundOrderItems> list = inboundOrderItemsService.selectInboundOrderItemsList(inboundOrderItems);
        ExcelUtil<InboundOrderItems> util = new ExcelUtil<InboundOrderItems>(InboundOrderItems.class);
        util.exportExcel(response, list, "入库单明细数据");
    }

    /**
     * 获取入库单明细详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(inboundOrderItemsService.selectInboundOrderItemsById(id));
    }

    /**
     * 新增入库单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:add')")
    @Log(title = "入库单明细", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody InboundOrderItems inboundOrderItems)
    {
        inboundOrderItems.setId(UUID.randomUUID().toString());
        return toAjax(inboundOrderItemsService.insertInboundOrderItems(inboundOrderItems));
    }

    /**
     * 修改入库单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:edit')")
    @Log(title = "入库单明细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody InboundOrderItems inboundOrderItems)
    {
        return toAjax(inboundOrderItemsService.updateInboundOrderItems(inboundOrderItems));
    }

    /**
     * 删除入库单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:remove')")
    @Log(title = "入库单明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(inboundOrderItemsService.deleteInboundOrderItemsByIds(ids));
    }

    /**
     * 导入入库单物料明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:import')")
    @Log(title = "物料信息导入", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importTemplate(MultipartFile file , boolean updateSupport) throws Exception
    {
        ExcelUtil<InboundOrderItems> util = new ExcelUtil<InboundOrderItems>(InboundOrderItems.class);
        List<InboundOrderItems> inboundOrderItems = util.importExcel(file.getInputStream());
        String operName = getUsername();
        String message = inboundOrderItemsService.importInboundOrderItems(inboundOrderItems, updateSupport, operName);
        return success(message);
    }

    /**
     * 统计入库单物料明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound_items:list')")
    @GetMapping("/details")
    public TableDataInfo itemDetails(InboundDetailsVO inboundDetailsVO) throws Exception
    {
        startPage();
        List<InboundDetailsVO> list = inboundOrderItemsService.selectInboundDetailsVOBySapNo();
        return getDataTable(list);
    }
}
