package com.ruoyi.inventory.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.inventory.domain.TO.StocktakesTO;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.Stocktakes;
import com.ruoyi.inventory.service.IStocktakesService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 库存盘点Controller
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@RestController
@RequestMapping("/inventory/stocktakes")
public class StocktakesController extends BaseController
{
    @Autowired
    private IStocktakesService stocktakesService;

    /**
     * 查询库存盘点列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:list')")
    @GetMapping("/list")
    public TableDataInfo list(Stocktakes stocktakes)
    {
        startPage();
        List<Stocktakes> list = stocktakesService.selectStocktakesList(stocktakes);
        return getDataTable(list);
    }

    /**
     * 导出库存盘点列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:export')")
    @Log(title = "库存盘点", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Stocktakes stocktakes)
    {
        List<Stocktakes> list = stocktakesService.selectStocktakesList(stocktakes);
        ExcelUtil<Stocktakes> util = new ExcelUtil<Stocktakes>(Stocktakes.class);
        util.exportExcel(response, list, "库存盘点数据");
    }

    /**
     * 获取库存盘点详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(stocktakesService.selectStocktakesById(id));
    }

    /**
     * 新增库存盘点
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:add')")
    @Log(title = "库存盘点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Stocktakes stocktakes)
    {
        return toAjax(stocktakesService.insertStocktakes(stocktakes));
    }

    /**
     * 修改库存盘点
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:edit')")
    @Log(title = "库存盘点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody StocktakesTO stocktakes)
    {
        return toAjax(stocktakesService.updateStocktakes(stocktakes));
    }

    /**
     * 删除库存盘点
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakes:remove')")
    @Log(title = "库存盘点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(stocktakesService.deleteStocktakesByIds(ids));
    }
}
