package com.ruoyi.inventory.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysUser;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.Owners;
import com.ruoyi.inventory.service.IOwnersService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 货主信息Controller
 *
 * @author ruoyi
 * @date 2025-11-28
 */
@RestController
@RequestMapping("/inventory/owners")
public class OwnersController extends BaseController
{
    @Autowired
    private IOwnersService ownersService;

    /**
     * 查询货主信息列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:owners:list')")
    @GetMapping("/list")
    public TableDataInfo list(Owners owners)
    {
        startPage();
        List<Owners> list = ownersService.selectOwnersList(owners);
        return getDataTable(list);
    }

    /**
     * 导出货主信息列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:owners:export')")
    @Log(title = "货主信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Owners owners)
    {
        List<Owners> list = ownersService.selectOwnersList(owners);
        ExcelUtil<Owners> util = new ExcelUtil<Owners>(Owners.class);
        util.exportExcel(response, list, "货主信息数据");
    }

    @PreAuthorize("@ss.hasPermi('inventory:owners:import')")
    @Log(title = "货主信息", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importTemplate(MultipartFile file , boolean updateSupport) throws Exception
    {
        ExcelUtil<Owners> util = new ExcelUtil<Owners>(Owners.class);
        List<Owners> ownersList = util.importExcel(file.getInputStream());
        String operName = getUsername();
        String message = ownersService.importOwners(ownersList, updateSupport, operName);
        return success(message);
    }
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<Owners> util = new ExcelUtil<Owners>(Owners.class);
        util.importTemplateExcel(response, "货主数据");
    }

    /**
     * 获取货主信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:owners:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(ownersService.selectOwnersById(id));
    }

    /**
     * 新增货主信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:owners:add')")
    @Log(title = "货主信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Owners owners)
    {
        return toAjax(ownersService.insertOwners(owners));
    }

    /**
     * 修改货主信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:owners:edit')")
    @Log(title = "货主信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Owners owners)
    {
        return toAjax(ownersService.updateOwners(owners));
    }

    /**
     * 删除货主信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:owners:remove')")
    @Log(title = "货主信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(ownersService.deleteOwnersByIds(ids));
    }
}
