import request from '@/utils/request'

// 查询出库单明细列表
export function listItems(query) {
  return request({
    url: '/inventory/items/list',
    method: 'get',
    params: query
  })
}

export function getStatistics(query) {
  return request({
    url: '/inventory/items/getStatistics',
    method: 'get',
    params: query
  })
}

// 查询出库单明细详细
export function getItems(id) {
  return request({
    url: '/inventory/items/' + id,
    method: 'get'
  })
}

// 新增出库单明细
export function addItems(data) {
  return request({
    url: '/inventory/items',
    method: 'post',
    data: data
  })
}

// 修改出库单明细
export function updateItems(data) {
  return request({
    url: '/inventory/items',
    method: 'put',
    data: data
  })
}

// 删除出库单明细
export function delItems(id) {
  return request({
    url: '/inventory/items/' + id,
    method: 'delete'
  })
}
// 查询出入库统计列表
export function listInboundOutboundStatistics(query) {
  return request({
    url: '/inventory/items/getStatistics',
    method: 'get',
    params: query
  })
}

// 导出出入库统计数据
export function exportInboundOutboundStatistics(query) {
  return request({
    url: '/inventory/items/inboundOutbound/export',
    method: 'post',
    params: query
  })
}


