package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.Warehouses;
import org.apache.ibatis.annotations.Update;

/**
 * 仓库Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
public interface WarehousesMapper 
{
    /**
     * 查询仓库
     * 
     * @param id 仓库主键
     * @return 仓库
     */
    public Warehouses selectWarehousesById(String id);

    /**
     * 查询仓库列表
     * 
     * @param warehouses 仓库
     * @return 仓库集合
     */
    public List<Warehouses> selectWarehousesList(Warehouses warehouses);

    /**
     * 新增仓库
     * 
     * @param warehouses 仓库
     * @return 结果
     */
    public int insertWarehouses(Warehouses warehouses);

    /**
     * 修改仓库
     * 
     * @param warehouses 仓库
     * @return 结果
     */
    public int updateWarehouses(Warehouses warehouses);

    /**
     * 删除仓库
     * 
     * @param id 仓库主键
     * @return 结果
     */
    public int deleteWarehousesById(String id);

    /**
     * 批量删除仓库
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWarehousesByIds(String[] ids);

    /**
     * 批量删除仓库
     *
     * @param id 需要删除的数据主键集合
     * @return 结果
     */
    @Update("update warehouses set is_enabled = 0 where id=#{id}")
    public int updateWarehouseStatus(String id);

}
