package com.ruoyi.inventory.domain;

import java.util.Date;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库存对象 inventory
 *
 * @author ruoyi
 * @date 2025-12-03
 */
@Data
public class Inventory extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 库存类别1普通2退库 */
    @Excel(name = "库存类别1普通2退库")
    private Long inventoryType;

    /** 入库单号 */
    @Excel(name = "入库单号")
    private String orderId;

    /** 物料ID 检索条件 */
    @Excel(name = "物料ID 检索条件")
    private String materialId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID 检索条件")
    private String batchId;
    /** 批次ID 检索条件 */
    @Excel(name = "仓库ID ")
    private String warehousesId;
    /** 仓库编码 检索条件 */
    private String warehousesCode;

    /** 库位ID 检索条件 */
    @Excel(name = "库位ID 检索条件")
    private String locationId;

    /** 货主ID 检索条件 */
    @Excel(name = "货主ID 检索条件")
    private String ownerId;

    /** 库存数量 */
    @Excel(name = "库存数量")
    private Long quantity;

    /** 锁定数量 */
    @Excel(name = "锁定数量")
    private Long lockedQuantity;

    /** 单位重量 */
    @Excel(name = "单位重量")
    private Long unitWeight;

    /** 总重量 暂无用 */
    @Excel(name = "总重量 暂无用")
    private Long totalWeight;

    /** 总体积 暂无用 */
    @Excel(name = "总体积 暂无用")
    private Long totalVolume;

    /** 生产日期 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生产日期 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date productionDate;

    /** 失效日期 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "失效日期 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expirationDate;

    /** 库存状态 0-已出库 1-正常 字典，检索条件 */
    @Excel(name = "库存状态 0-已出库 1-正常 字典，检索条件")
    private Long inventoryStatus;

    /** 最后入库时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最后入库时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lastInboundTime;

    /** 最后出库时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最后出库时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lastOutboundTime;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    /** 预警类型 */
    private String alertType;

    /** 物料名称 */
    @ExcelProperty(value = "物料名称", index = 1)
    private String materialName;

    /** 最低库存 */
    private Long minStockLevel;
    /** 最高库存 */
    private Long maxStockLevel;

    /** SAP物料号 */
    @Excel(name = "SAP物料号")
    private String sapNo;

    /** TS Code */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 危险类别 */
    private String hazardId;

    /** 危险类别 */
    @Excel(name = "危险类别")
    private String hazard;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String specification;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String materialUnit;

    /** 包装重量 */
//    @Excel(name = "包装重量")
    private Double packageWeight;

    /** 体积 */
    private Double volume;

    /** 保质期天数 */
    private Integer shelfLifeDays;

    /** 存储温度要求 */
//    @Excel(name = "存储温度要求")
    private String storageTemperature;

    /** 特殊存储要求 */
//    @Excel(name = "特殊存储要求")
    private String specialRequirements;

    private String warehousesName;
    private String locationName;
    private String ownerName;


    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("inventoryType", getInventoryType())
            .append("orderId", getOrderId())
            .append("materialId", getMaterialId())
            .append("batchId", getBatchId())
            .append("locationId", getLocationId())
            .append("ownerId", getOwnerId())
            .append("quantity", getQuantity())
            .append("lockedQuantity", getLockedQuantity())
            .append("unitWeight", getUnitWeight())
            .append("totalWeight", getTotalWeight())
            .append("totalVolume", getTotalVolume())
            .append("productionDate", getProductionDate())
            .append("expirationDate", getExpirationDate())
            .append("inventoryStatus", getInventoryStatus())
            .append("lastInboundTime", getLastInboundTime())
            .append("lastOutboundTime", getLastOutboundTime())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
