package com.ruoyi.inventory.service;

import java.util.List;

import com.ruoyi.inventory.domain.InboundOrders;
import com.ruoyi.inventory.domain.vo.InboundMaterialTotalVO;


/**
 * 入库单主Service接口
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
public interface IInboundOrdersService 
{
    /**
     * 查询入库单主
     * 
     * @param id 入库单主主键
     * @return 入库单主
     */
    public InboundOrders selectInboundOrdersById(String id);

    /**
     * 查询入库单主列表
     * 
     * @param inboundOrders 入库单主
     * @return 入库单主集合
     */
    public List<InboundOrders> selectInboundOrdersList(InboundOrders inboundOrders);

    /**
     * 新增入库单主
     * 
     * @param inboundOrders 入库单主
     * @return 结果
     */
    public int insertInboundOrders(InboundOrders inboundOrders);

    /**
     * 修改入库单主
     * 
     * @param inboundOrders 入库单主
     * @return 结果
     */
    public int updateInboundOrders(InboundOrders inboundOrders);

    /**
     * 批量删除入库单主
     * 
     * @param ids 需要删除的入库单主主键集合
     * @return 结果
     */
    public int deleteInboundOrdersByIds(String[] ids);

    /**
     * 删除入库单主信息
     * 
     * @param id 入库单主主键
     * @return 结果
     */
    public int deleteInboundOrdersById(String id);

    /**
     * 导入入库单明细信息
     *
     * @param  inboundOrders,isUpdateSupport,operName 入库单数据信息
     * @return 结果
     */
    public <T> String importInboundOrders(List<T> inboundOrders, Integer isUpdateSupport, String operName, Integer orderType);


    /**
     * 统计本月入库数量
     *
     * @return 结果
     */
    public int countInboundOrders();

    /**
     * 按数量统计本月入库物料Top前10
     * @return 结果
     */
    public List<InboundMaterialTotalVO> countInboundMaterialQuantity();

    /**
     * 按金额统计本月入库物料Top前10
     * @return 结果
     */
    public List<InboundMaterialTotalVO> countInboundMaterialMoney();
}
