import request from '@/utils/request'

// 查询盘点单明细列表
export function listItems(query) {
  return request({
    url: '/inventory/items/list',
    method: 'get',
    params: query
  })
}

// 查询盘点单明细详细
export function getItems(id) {
  return request({
    url: '/inventory/items/' + id,
    method: 'get'
  })
}

// 新增盘点单明细
export function addItems(data) {
  return request({
    url: '/inventory/items',
    method: 'post',
    data: data
  })
}

// 修改盘点单明细
export function updateItems(data) {
  return request({
    url: '/inventory/items',
    method: 'put',
    data: data
  })
}

// 删除盘点单明细
export function delItems(id) {
  return request({
    url: '/inventory/items/' + id,
    method: 'delete'
  })
}

// 盘盈金额 盘亏金额
export function stocktakeVarianceAmount() {
  return request({
    url: '/inventory/items/stocktakeVarianceAmount',
    method: 'get'
  })
}

// 3. 本月差异分析
export function varianceAnalysis() {
  return request({
    url: '/inventory/items/varianceAnalysis',
    method: 'get'
  })
}
