package com.ruoyi.inventory.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 出库单明细对象 outbound_order_items
 *
 * @author ruoyi
 * @date 2025-12-03
 */
@Data
public class OutboundOrderItems extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 出库单号 检索条件 */
    @Excel(name = "出库单号 检索条件")
    private String orderId;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "货物ID 字典，检索条件")
    private String materialId;

    // 新增：Mapper中映射的materialName字段
    /** 货物名称 */
    private String materialName;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "ID 字典，检索条件")
    private String locationId;

    // 新增：Mapper中映射的locationName字段
    /** 库位名称 */
    private String locationName;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID 检索条件")
    private String batchCode;

    /** 仓库ID 检索条件 */
    @Excel(name = "仓库ID 检索条件")
    private String warehouseId;

    // 新增：Mapper中映射的warehouseName字段（解决核心报错）
    /** 仓库名称 */
    private String warehouseName;

    /** 库存ID */
    private String inventoryId;

    /** 出库单ID */
    private String outboundOrderId;

    // 新增：Mapper中映射的inboundOrderId字段
    /** 入库单ID */
    private String inboundOrderId;

    /** 单价 */
    @Excel(name = "单价")
    private Double unitPrice;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Long actualQuantity;

    /** 约数 */
    @Excel(name = "约数")
    private Double divisor;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色 字典，检索条件")
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号 检索条件")
    private String voucherNumber;

    /** 状态1-待发货 2-部分发货 3-已完成 字典，检索条件 */
    @Excel(name = "状态1-待发货 2-部分发货 3-已完成 字典，检索条件")
    private Long itemStatus;

    /** 发货时间 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "发货时间 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date shippedAt;

    /** 发货方 暂无用 */
    @Excel(name = "发货方 暂无用")
    private String shippedBy;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    private int InventoryType;


}