package com.ruoyi.inventory.domain.TO;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 出库单明细对象 outbound_order_items
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public class OutboundOrderItemsStatisticsVO extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 出库单号 检索条件 */
    @Excel(name = "出库单号 检索条件")
    private String orderId;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "货物ID 字典，检索条件")
    private String materialId;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "ID 字典，检索条件")
    private String locationId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID 检索条件")
    private String batchCode;

    /** 仓库ID 检索条件 */
    @Excel(name = "仓库ID 检索条件")
    private String warehouseId;


    /** 库存ID */
    private String inventoryId;

    /** 出库单ID */
    private String outboundOrderId;

    /** 单价 */
    @Excel(name = "单价")
    private Long unitPrice;
    /**
     * amount（对应SQL：(unit_price*actual_quantity) AS amount）
     */
    private String amount;
    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Long actualQuantity;

    /** 约数 */
    @Excel(name = "约数")
    private Long divisor;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色 字典，检索条件")
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号 检索条件")
    private String voucherNumber;

    /** 状态1-待发货 2-部分发货 3-已完成 字典，检索条件 */
    @Excel(name = "状态1-待发货 2-部分发货 3-已完成 字典，检索条件")
    private Long itemStatus;

    /** 发货时间 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "发货时间 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date shippedAt;

    private Date startDate;

    private Date endDate;

    /** 发货方 暂无用 */
    @Excel(name = "发货方 暂无用")
    private String shippedBy;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    public String getInventoryId() {
        return inventoryId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public String getOutboundOrderId() {
        return outboundOrderId;
    }

    public void setOutboundOrderId(String outboundOrderId) {
        this.outboundOrderId = outboundOrderId;
    }

    public Long getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Long unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setMaterialId(String materialId) 
    {
        this.materialId = materialId;
    }

    public String getMaterialId() 
    {
        return materialId;
    }

    public void setBatchCode(String batchCode) 
    {
        this.batchCode = batchCode;
    }

    public String getBatchCode() 
    {
        return batchCode;
    }

    public void setWarehouseId(String warehouseId) 
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId() 
    {
        return warehouseId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setLocationId(String locationId)
    {
        this.locationId = locationId;
    }

    public String getLocationId() 
    {
        return locationId;
    }

    public void setPlannedQuantity(Long plannedQuantity) 
    {
        this.plannedQuantity = plannedQuantity;
    }

    public Long getPlannedQuantity() 
    {
        return plannedQuantity;
    }

    public void setActualQuantity(Long actualQuantity) 
    {
        this.actualQuantity = actualQuantity;
    }

    public Long getActualQuantity() 
    {
        return actualQuantity;
    }

    public void setDivisor(Long divisor) 
    {
        this.divisor = divisor;
    }

    public Long getDivisor() 
    {
        return divisor;
    }

    public void setLabelColor(Long labelColor) 
    {
        this.labelColor = labelColor;
    }

    public Long getLabelColor() 
    {
        return labelColor;
    }

    public void setVoucherNumber(String voucherNumber) 
    {
        this.voucherNumber = voucherNumber;
    }

    public String getVoucherNumber() 
    {
        return voucherNumber;
    }

    public void setItemStatus(Long itemStatus) 
    {
        this.itemStatus = itemStatus;
    }

    public Long getItemStatus() 
    {
        return itemStatus;
    }

    public void setShippedAt(Date shippedAt) 
    {
        this.shippedAt = shippedAt;
    }

    public Date getShippedAt() 
    {
        return shippedAt;
    }

    public void setShippedBy(String shippedBy) 
    {
        this.shippedBy = shippedBy;
    }

    public String getShippedBy() 
    {
        return shippedBy;
    }

    public void setIsUsed(Long isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed() 
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("orderId", getOrderId())
            .append("materialId", getMaterialId())
            .append("batchCode", getBatchCode())
            .append("warehouseId", getWarehouseId())
            .append("locationId", getLocationId())
            .append("inventoryId", getInventoryId())
            .append("outboundOrderId", getOutboundOrderId())
            .append("unitPrice", getUnitPrice())
            .append("plannedQuantity", getPlannedQuantity())
            .append("actualQuantity", getActualQuantity())
            .append("divisor", getDivisor())
            .append("amount", getAmount())
            .append("labelColor", getLabelColor())
            .append("voucherNumber", getVoucherNumber())
            .append("itemStatus", getItemStatus())
            .append("shippedAt", getShippedAt())
            .append("shippedBy", getShippedBy())
            .append("remark", getRemark())
            .append("endDate", getEndDate())
            .append("startDate", getStartDate())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
