package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.domain.TO.OutboundOrderItemsStatisticsVO;

/**
 * 出库单明细Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IOutboundOrderItemsService
{
    /**
     * 查询出库单明细
     * 
     * @param id 出库单明细主键
     * @return 出库单明细
     */
    public OutboundOrderItems selectOutboundOrderItemsById(String id);

    /**
     * 查询出库单明细列表
     * 
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细集合
     */
    public List<OutboundOrderItems> selectOutboundOrderItemsList(OutboundOrderItems outboundOrderItems);
    /**
     * 查询出库单明细统计
     *
     * @param outboundOrderItems 出库单明细
     * @return 出库单明细集合
     */
    public List<OutboundOrderItems> selectOutboundOrderItemsStatistics(OutboundOrderItemsStatisticsVO outboundOrderItems);
    /**
     * 新增出库单明细
     * 
     * @param outboundOrderItems 出库单明细
     * @return 结果
     */
    public int insertOutboundOrderItems(OutboundOrderItems outboundOrderItems);

    /**
     * 修改出库单明细
     * 
     * @param outboundOrderItems 出库单明细
     * @return 结果
     */
    public int updateOutboundOrderItems(OutboundOrderItems outboundOrderItems);

    /**
     * 批量删除出库单明细
     * 
     * @param ids 需要删除的出库单明细主键集合
     * @return 结果
     */
    public int deleteOutboundOrderItemsByIds(String[] ids);

    /**
     * 删除出库单明细信息
     * 
     * @param id 出库单明细主键
     * @return 结果
     */
    public int deleteOutboundOrderItemsById(String id);
}
