package com.ruoyi.inventory.service;

import java.util.List;
import java.util.Map;

import com.ruoyi.inventory.domain.OutboundOrders;
import com.ruoyi.inventory.domain.vo.OutboundTemplateVO;
import org.springframework.transaction.annotation.Transactional;

/**
 * 出库单主Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IOutboundOrdersService 
{
    /**
     * 查询出库单主
     * 
     * @param id 出库单主主键
     * @return 出库单主
     */
    public OutboundOrders selectOutboundOrdersById(String id);

    /**
     * 查询出库单主列表
     * 
     * @param outboundOrders 出库单主
     * @return 出库单主集合
     */
    public List<OutboundOrders> selectOutboundOrdersList(OutboundOrders outboundOrders);

    /**
     * 新增出库单主
     * 
     * @param outboundOrders 出库单主
     * @return 结果
     */
    public int insertOutboundOrders(OutboundOrders outboundOrders);

    /**
     * 修改出库单主
     * 
     * @param outboundOrders 出库单主
     * @return 结果
     */
    public int updateOutboundOrders(OutboundOrders outboundOrders);

    /**
     * 批量删除出库单主
     * 
     * @param ids 需要删除的出库单主主键集合
     * @return 结果
     */
    public int deleteOutboundOrdersByIds(String[] ids);

    /**
     * 删除出库单主信息
     * 
     * @param id 出库单主主键
     * @return 结果
     */
    public int deleteOutboundOrdersById(String id);

    /**
     * 出货
     *
     * @param id 出库单主主键
     * @return 结果
     */
    public int ship(OutboundOrders outboundOrders);

    public List<Map<String,String>> outboundOrdersTopTenByQuantity();

    public List<Map<String,String>> outboundOrdersTopTenByAmount();

    public String outboundOrdersCount();

    @Transactional(rollbackFor = Exception.class)
    String importOutboundOrders(List<OutboundTemplateVO> inboundOrdersList, Boolean isUpdateSupport, String operName,Integer orderType);

    public List<OutboundTemplateVO> selectOutboundOrdersExportList(OutboundOrders outboundOrders);
}
