package com.ruoyi.inventory.service;

import java.util.List;
import java.util.Map;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.inventory.domain.StocktakeItems;
import com.ruoyi.inventory.domain.TO.StocktakeItemsTo;
import com.ruoyi.inventory.domain.TO.StocktakesVo;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 盘点单明细Service接口
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public interface IStocktakeItemsService
{
    /**
     * 查询盘点单明细
     *
     * @param id 盘点单明细主键
     * @return 盘点单明细
     */
    public StocktakeItems selectStocktakeItemsById(String id);

    // 主表调用
    public List<StocktakeItemsTo> selectStocktakeItemsByMain(Map<String,Object> query);

    /**
     * 查询盘点单明细列表
     *
     * @param stocktakeItems 盘点单明细
     * @return 盘点单明细集合
     */
    public List<StocktakeItems> selectStocktakeItemsList(StocktakeItems stocktakeItems);

    /**
     * 新增盘点单明细
     *
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    public int insertStocktakeItems(StocktakeItems stocktakeItems);

    /**
     * 修改盘点单明细
     *
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    public int updateStocktakeItems(StocktakeItems stocktakeItems);

    /**
     * 批量删除盘点单明细
     *
     * @param ids 需要删除的盘点单明细主键集合
     * @return 结果
     */
    public int deleteStocktakeItemsByIds(String[] ids);

    /**
     * 删除盘点单明细信息
     *
     * @param id 盘点单明细主键
     * @return 结果
     */
    public int deleteStocktakeItemsById(String id);

//    查询处理统计-详情
    public List<StocktakesVo> selectStocktakesCountInfo(StocktakesVo stocktakes);

    /**
     * @description: 本月 盘盈金额 和 盘亏金额
     * @author cs
     * @date 2025/12/10
     * @version 1.0
     */
    public Map<String, Object> stocktakeVarianceAmount();

    /**
     * @description: 本月 本月差异分析
     * @author cs
     * @date 2025/12/10
     * @version 1.0
     */
    public Map<String, Object> selectItemsVarianceAnalysis();

    public Map<String,Object> getMonthDay();
}
