package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 出库单明细对象 outbound_order_items
 *
 * @author ruoyi
 * @date 2025-12-03
 */
public class OutboundTemplateVO extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 日期（入库日期） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundDate;

    /** SAP号 */
    @Excel(name = "SAP No")
    private String sapNo;

    /** 物料ID */
    private String materialId;

    /** 货物名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** TS Code */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 批号 */
    @Excel(name = " 批号")
    private String batchCode;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    /** 件重 */
    @Excel(name = "件重")
    private Long pieceWeight;

    /** 件数（实际件数） */
    @Excel(name = "件数")
    private Long actualPackages;

    /** 实发数量（实际数量） */
    @Excel(name = "实发数量")
    private Long actualQuantity;

    /** 库位名称 */
    @Excel(name = "库位")
    private String locationName;

    /** 库位ID */
    private String locationId;

    /** 仓库ID */
    private String warehouseId;

    /** 仓库名称 */
    @Excel(name = "仓库")
    private String warehouseName;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 标签颜色 */
    @Excel(name = "标签颜色",dictType = "label_color")
    private Long labelColor;

    /** 凭证号 */
    @Excel(name = "凭证号")
    private String voucherNumber;

    /** 保温状态/类型 */
    @Excel(name = "保温")
    private String insulation;

    /** 危检类别（危险类别） */
    @Excel(name = "危险类别")
    private String dangerCheckType;

    /** 单号 */
    @Excel(name = "单号")
    private String orderId;

    /** 系统编号（系统单号） */
    @Excel(name = "系统单号")
    private String systemNo;

    /** 订单类型 */
    @Excel(name = "订单类型")
    private String orderType;

    /** 货主ID */
    private String ownerId;

    /** 货主名称 */
    @Excel(name = "货主")
    private String ownerName;

    /** 目的地 */
    @Excel(name = "目的地")
    private String destination;

    /** 预留 */
    @Excel(name = "预留")
    private String reservation;

    /** 单个件重值（单件重量） */
    @Excel(name = "单件重量")
    private Long singlePieceWeight;

    // ===================== Getter & Setter 完整实现 =====================
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getInboundDate() {
        return inboundDate;
    }

    public void setInboundDate(Date inboundDate) {
        this.inboundDate = inboundDate;
    }

    public String getSapNo() {
        return sapNo;
    }

    public void setSapNo(String sapNo) {
        this.sapNo = sapNo;
    }

    public void setTsCode(String tsCode) {
        this.tsCode = tsCode;
    }

    public String getBatchCode() {
        return batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getTsCode() {
        return tsCode;
    }

    public void setTsCo(String tsCode) {
        this.tsCode = tsCode;
    }


    public Long getPlannedQuantity() {
        return plannedQuantity;
    }

    public void setPlannedQuantity(Long plannedQuantity) {
        this.plannedQuantity = plannedQuantity;
    }

    public Long getPieceWeight() {
        return pieceWeight;
    }

    public void setPieceWeight(Long pieceWeight) {
        this.pieceWeight = pieceWeight;
    }

    public Long getActualPackages() {
        return actualPackages;
    }

    public void setActualPackages(Long actualPackages) {
        this.actualPackages = actualPackages;
    }

    public Long getActualQuantity() {
        return actualQuantity;
    }

    public void setActualQuantity(Long actualQuantity) {
        this.actualQuantity = actualQuantity;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getLabelColor() {
        return labelColor;
    }

    public void setLabelColor(Long labelColor) {
        this.labelColor = labelColor;
    }

    public String getVoucherNumber() {
        return voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public String getInsulation() {
        return insulation;
    }

    public void setInsulation(String insulation) {
        this.insulation = insulation;
    }

    public String getDangerCheckType() {
        return dangerCheckType;
    }

    public void setDangerCheckType(String dangerCheckType) {
        this.dangerCheckType = dangerCheckType;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSystemNo() {
        return systemNo;
    }

    public void setSystemNo(String systemNo) {
        this.systemNo = systemNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getReservation() {
        return reservation;
    }

    public void setReservation(String reservation) {
        this.reservation = reservation;
    }

    public Long getSinglePieceWeight() {
        return singlePieceWeight;
    }

    public void setSinglePieceWeight(Long singlePieceWeight) {
        this.singlePieceWeight = singlePieceWeight;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", id)
                .append("inboundDate", inboundDate)
                .append("sapNo", sapNo)
                .append("materialId", materialId)
                .append("materialName", materialName)
                .append("tsCode", tsCode)
                .append("plannedQuantity", plannedQuantity)
                .append("pieceWeight", pieceWeight)
                .append("actualPackages", actualPackages)
                .append("actualQuantity", actualQuantity)
                .append("locationName", locationName)
                .append("locationId", locationId)
                .append("warehouseId", warehouseId)
                .append("warehouseName", warehouseName)
                .append("remark", remark)
                .append("labelColor", labelColor)
                .append("voucherNumber", voucherNumber)
                .append("insulation", insulation)
                .append("dangerCheckType", dangerCheckType)
                .append("orderId", orderId)
                .append("systemNo", systemNo)
                .append("orderType", orderType)
                .append("ownerId", ownerId)
                .append("ownerName", ownerName)
                .append("destination", destination)
                .append("reservation", reservation)
                .append("singlePieceWeight", singlePieceWeight)
                .toString();
    }
}