package com.ruoyi.inventory.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 物料对象 materials
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public class Materials extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 物料编码 检索条件 */
    @Excel(name = "物料编码")
    private String materialCode;

    /** 物料名称 检索条件 */
    @Excel(name = "物料名称")
    private String materialName;

    /** SAP物料号 检索条件 */
    @Excel(name = "SAP物料号")
    private String sapNo;

    /** TS Code 检索条件 */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 物料分类 检索条件 */
    @Excel(name = "物料分类")
    private String categoryCode;

    /** 危险类别ID 字典 */
    @Excel(name = "危险类别ID")
    private String hazardId;

    /** 规格型号 检索条件 */
    @Excel(name = "规格型号")
    private String specification;

    /** 计量单位 字典 */
    @Excel(name = "计量单位")
    private String materialUnit;

    /** 单位重量 */
    @Excel(name = "单位重量")
    private Long unitWeight;

    /** 包装重量 */
    @Excel(name = "包装重量")
    private Long packageWeight;

    /** 总重量 */
    @Excel(name = "总重量")
    private Long totalWeight;

    /** 体积 */
    @Excel(name = "体积")
    private Long volume;

    /** 保质期天数 */
    @Excel(name = "保质期天数")
    private Long shelfLifeDays;

    /** 存储温度要求 */
    @Excel(name = "存储温度要求")
    private String storageTemperature;

    /** 特殊存储要求 */
    @Excel(name = "特殊存储要求")
    private String specialRequirements;

    /** 是否批次管理 1-是 0-否 */
    @Excel(name = "是否批次管理 1-是 0-否")
    private Long isBatchManaged;

    /** 是否序列号管理 1-是 0-否 */
    @Excel(name = "是否序列号管理 1-是 0-否")
    private Long isSerialManaged;

    /** 最低库存 */
    @Excel(name = "最低库存")
    private Long minStockLevel;

    /** 最高库存 */
    @Excel(name = "最高库存")
    private Long maxStockLevel;

    /** 是否正在使用 1-是 0-否 */
    @Excel(name = "是否正在使用 1-是 0-否")
    private Long isUsed;

    /** 是否激活 1-是 0-否 */
    @Excel(name = "是否激活 1-是 0-否")
    private Long isActive;

    /** 风险等级 字典 */
    @Excel(name = "风险等级")
    private String riskLevel;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setMaterialCode(String materialCode) 
    {
        this.materialCode = materialCode;
    }

    public String getMaterialCode() 
    {
        return materialCode;
    }

    public void setMaterialName(String materialName) 
    {
        this.materialName = materialName;
    }

    public String getMaterialName() 
    {
        return materialName;
    }

    public void setSapNo(String sapNo) 
    {
        this.sapNo = sapNo;
    }

    public String getSapNo() 
    {
        return sapNo;
    }

    public void setTsCode(String tsCode) 
    {
        this.tsCode = tsCode;
    }

    public String getTsCode() 
    {
        return tsCode;
    }

    public void setCategoryCode(String categoryCode) 
    {
        this.categoryCode = categoryCode;
    }

    public String getCategoryCode() 
    {
        return categoryCode;
    }

    public void setHazardId(String hazardId) 
    {
        this.hazardId = hazardId;
    }

    public String getHazardId() 
    {
        return hazardId;
    }

    public void setSpecification(String specification) 
    {
        this.specification = specification;
    }

    public String getSpecification() 
    {
        return specification;
    }

    public void setMaterialUnit(String materialUnit) 
    {
        this.materialUnit = materialUnit;
    }

    public String getMaterialUnit() 
    {
        return materialUnit;
    }

    public void setUnitWeight(Long unitWeight) 
    {
        this.unitWeight = unitWeight;
    }

    public Long getUnitWeight() 
    {
        return unitWeight;
    }

    public void setPackageWeight(Long packageWeight) 
    {
        this.packageWeight = packageWeight;
    }

    public Long getPackageWeight() 
    {
        return packageWeight;
    }

    public void setTotalWeight(Long totalWeight) 
    {
        this.totalWeight = totalWeight;
    }

    public Long getTotalWeight() 
    {
        return totalWeight;
    }

    public void setVolume(Long volume) 
    {
        this.volume = volume;
    }

    public Long getVolume() 
    {
        return volume;
    }

    public void setShelfLifeDays(Long shelfLifeDays) 
    {
        this.shelfLifeDays = shelfLifeDays;
    }

    public Long getShelfLifeDays() 
    {
        return shelfLifeDays;
    }

    public void setStorageTemperature(String storageTemperature) 
    {
        this.storageTemperature = storageTemperature;
    }

    public String getStorageTemperature() 
    {
        return storageTemperature;
    }

    public void setSpecialRequirements(String specialRequirements) 
    {
        this.specialRequirements = specialRequirements;
    }

    public String getSpecialRequirements() 
    {
        return specialRequirements;
    }

    public void setIsBatchManaged(Long isBatchManaged) 
    {
        this.isBatchManaged = isBatchManaged;
    }

    public Long getIsBatchManaged() 
    {
        return isBatchManaged;
    }

    public void setIsSerialManaged(Long isSerialManaged) 
    {
        this.isSerialManaged = isSerialManaged;
    }

    public Long getIsSerialManaged() 
    {
        return isSerialManaged;
    }

    public void setMinStockLevel(Long minStockLevel) 
    {
        this.minStockLevel = minStockLevel;
    }

    public Long getMinStockLevel() 
    {
        return minStockLevel;
    }

    public void setMaxStockLevel(Long maxStockLevel) 
    {
        this.maxStockLevel = maxStockLevel;
    }

    public Long getMaxStockLevel() 
    {
        return maxStockLevel;
    }

    public Long getIsUsed() { return isUsed; }

    public void setIsUsed(Long isUsed) { this.isUsed = isUsed; }

    public void setIsActive(Long isActive)
    {
        this.isActive = isActive;
    }

    public Long getIsActive() 
    {
        return isActive;
    }

    public void setRiskLevel(String riskLevel) 
    {
        this.riskLevel = riskLevel;
    }

    public String getRiskLevel() 
    {
        return riskLevel;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("materialCode", getMaterialCode())
            .append("materialName", getMaterialName())
            .append("sapNo", getSapNo())
            .append("tsCode", getTsCode())
            .append("categoryCode", getCategoryCode())
            .append("hazardId", getHazardId())
            .append("specification", getSpecification())
            .append("materialUnit", getMaterialUnit())
            .append("unitWeight", getUnitWeight())
            .append("packageWeight", getPackageWeight())
            .append("totalWeight", getTotalWeight())
            .append("volume", getVolume())
            .append("shelfLifeDays", getShelfLifeDays())
            .append("storageTemperature", getStorageTemperature())
            .append("specialRequirements", getSpecialRequirements())
            .append("isBatchManaged", getIsBatchManaged())
            .append("isSerialManaged", getIsSerialManaged())
            .append("minStockLevel", getMinStockLevel())
            .append("maxStockLevel", getMaxStockLevel())
            .append("isUsed",getIsUsed())
            .append("isActive", getIsActive())
            .append("riskLevel", getRiskLevel())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
