package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.Materials;
import org.apache.ibatis.annotations.Param;

/**
 * 物料Mapper接口
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public interface MaterialsMapper 
{
    /**
     * 查询物料
     * 
     * @param id 物料主键
     * @return 物料
     */
    public Materials selectMaterialsById(String id);

    /**
     * 查询物料列表
     * 
     * @param materials 物料
     * @return 物料集合
     */
    public List<Materials> selectMaterialsList(Materials materials);

    /**
     * 新增物料
     * 
     * @param materials 物料
     * @return 结果
     */
    public int insertMaterials(Materials materials);

    /**
     * 修改物料
     * 
     * @param materials 物料
     * @return 结果
     */
    public int updateMaterials(Materials materials);

    /**
     * 删除物料
     * 
     * @param id 物料主键
     * @return 结果
     */
    public int deleteMaterialsById(String id);

    /**
     * 批量删除物料
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMaterialsByIds(String[] ids);

    public int updateMaterialsIsUsedByIds(String[] ids);

}
