package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.MaterialsCategory;

/**
 * 物料分类Service接口
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public interface IMaterialsCategoryService 
{
    /**
     * 查询物料分类
     * 
     * @param id 物料分类主键
     * @return 物料分类
     */
    public MaterialsCategory selectMaterialsCategoryById(String id);

    /**
     * 查询物料分类列表
     * 
     * @param materialsCategory 物料分类
     * @return 物料分类集合
     */
    public List<MaterialsCategory> selectMaterialsCategoryList(MaterialsCategory materialsCategory);

    /**
     * 新增物料分类
     * 
     * @param materialsCategory 物料分类
     * @return 结果
     */
    public int insertMaterialsCategory(MaterialsCategory materialsCategory);

    /**
     * 修改物料分类
     * 
     * @param materialsCategory 物料分类
     * @return 结果
     */
    public int updateMaterialsCategory(MaterialsCategory materialsCategory);

    /**
     * 批量删除物料分类
     * 
     * @param ids 需要删除的物料分类主键集合
     * @return 结果
     */
    public int deleteMaterialsCategoryByIds(String[] ids);

    /**
     * 删除物料分类信息
     * 
     * @param id 物料分类主键
     * @return 结果
     */
    public int deleteMaterialsCategoryById(String id);
}
